package simtools;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.distribution.NormalDistribution;

/**
 * Calculates an expected value for a given cumulative probability density function F
 * @author Bogumil Kaminski & Przemyslaw Szufel
 */
public class CalculateEv {

	/**
	 * Testing code...
	 * @param args
	 */
	public static void test() {
		final NormalDistribution dist_1 = new NormalDistribution(-1,1);
		final NormalDistribution dist0 = new NormalDistribution(0,1);
		final NormalDistribution dist1 = new NormalDistribution(1,1);
		final UnivariateFunction F = new UnivariateFunction() {				
			@Override
			public double value(double x) {
				double val = dist_1.cumulativeProbability(x)*dist0.cumulativeProbability(x)*dist1.cumulativeProbability(x);
				return val;
			}
		};
		double v;
		long t = System.currentTimeMillis();
		v = calculateEV_KG(F);
	    System.out.println("calculateEV_KG "+v+" "+(System.currentTimeMillis()-t));
	}
	
	

	
    private final static double[] gkx = {-0.999484410050490637571, -0.996893484074649540272, -0.991630996870404594859, -0.98366812327974720997, -0.973116322501126268375, -0.960021864968307512217, -0.944374444748559979416, -0.926200047429274325879, -0.905573307699907798547, -0.882560535792052681543, -0.857205233546061098959, -0.829565762382768397443, -0.799727835821839083014, -0.767777432104826194918, -0.733790062453226804726, -0.697850494793315796932, -0.66006106412662696137, -0.6205261829892428611405, -0.579345235826361691756, -0.5366241481420198992642, -0.4924804678617785749937, -0.447033769538089176781, -0.4004012548303943925355, -0.352704725530878113471, -0.3040732022736250773727, -0.2546369261678898464398, -0.204525116682309891439, -0.1538699136085835469638, -0.1028069379667370301471, -0.051471842555317695833, 0, 0.051471842555317695833, 0.1028069379667370301471, 0.153869913608583546964, 0.204525116682309891439, 0.2546369261678898464398, 0.3040732022736250773727, 0.352704725530878113471, 0.4004012548303943925355, 0.447033769538089176781, 0.492480467861778574994, 0.536624148142019899264, 0.579345235826361691756, 0.62052618298924286114, 0.66006106412662696137, 0.697850494793315796932, 0.733790062453226804726, 0.767777432104826194918, 0.799727835821839083014, 0.829565762382768397443, 0.857205233546061098959, 0.882560535792052681543, 0.905573307699907798547, 0.926200047429274325879, 0.944374444748559979416, 0.960021864968307512217, 0.973116322501126268375, 0.98366812327974720997, 0.991630996870404594859, 0.996893484074649540272, 0.999484410050490637571};
    private final static double[] gkw = {0.001389013698677007625, 0.00389046112709988405127, 0.006630703915931292173, 0.009273279659517763428, 0.011823015253496341742, 0.014369729507045804813, 0.01692088918905327262745, 0.019414141193942381173, 0.021828035821609192297, 0.024191162078080601366, 0.0265099548823331016106, 0.028754048765041292844, 0.0309072575623877624729, 0.0329814470574837260318, 0.034979338028060024137, 0.0368823646518212292239, 0.03867894562472759295, 0.0403745389515359591122, 0.0419698102151642461471, 0.043452539701356069316, 0.0448148001331626631925, 0.046059238271006988116, 0.047185546569299153945, 0.048185861757087129141, 0.049055434555029778888, 0.049795683427074206358, 0.0504059214027823468409, 0.050881795898749606492, 0.051221547849258772171, 0.051426128537459025934, 0.051494729429451567558, 0.051426128537459025934, 0.0512215478492587721707, 0.050881795898749606492, 0.050405921402782346841, 0.049795683427074206358, 0.0490554345550297788875, 0.048185861757087129141, 0.047185546569299153945, 0.046059238271006988116, 0.044814800133162663192, 0.0434525397013560693168, 0.041969810215164246147, 0.040374538951535959112, 0.03867894562472759295, 0.036882364651821229224, 0.034979338028060024137, 0.032981447057483726032, 0.0309072575623877624729, 0.028754048765041292844, 0.026509954882333101611, 0.0241911620780806013658, 0.021828035821609192297, 0.019414141193942381173, 0.0169208891890532726276, 0.014369729507045804812, 0.011823015253496341742, 0.009273279659517763428, 0.0066307039159312921733, 0.003890461127099884051, 0.001389013698677007625};

	
	public static double calculateEV_KG(final UnivariateFunction F) {
		return calculateEV_KG(0, 1, F, Double.NaN);
	}

	public static double calculateEV_KG(double xmin, double xmax, final UnivariateFunction F, double base) {
		if (Double.isNaN(base)) {
			base = int_KG(xmin, xmax, F);
		}
		double mid = (xmin + xmax) / 2;
		double leftint = int_KG(xmin, mid, F);
		double rightint = int_KG(mid, xmax, F);
		double refined = leftint + rightint;
		if (Math.abs(refined - base) < 1e-12) {
			return refined;
		}
		return calculateEV_KG(xmin, mid, F, leftint) + calculateEV_KG(mid, xmax, F, rightint);
	}

	private static double int_KG(double xmin, double xmax,final UnivariateFunction F) {
		double quad = 0;
		double range = (xmax - xmin) / 2;
		double mean = (xmax + xmin) / 2;
		for (int i = 0; i < 61; i++) {
			double x = gkx[i] * range + mean;
			quad += range * gkw[i]
					* (1 - F.value((1 - x) / x) - F.value(-(1 - x) / x))
					/ (x * x);
		}
		return quad;
	}

}
