package logging;

import java.io.File;
import java.io.FileOutputStream;
/**
 * Outputs logs to a log file.
 * @author Bogumil Kaminski & Przemyslaw Szufel
 */
public class StoreLogFile implements StoreLog {

	private File folder;
	public StoreLogFile (File folder) {
		this.folder = folder;
	}

	@Override
	public void store(String fileName, byte[] log) {
		try {
			FileOutputStream fos = new FileOutputStream(new File(folder,fileName));
			fos.write(log);
			fos.close();
		} catch (Exception ex) {
			ex.printStackTrace();
		}
		
	}

}
