/*
 * Decompiled with CFR 0.152.
 */
package sim.util.media.chart;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.SeriesChangeListener;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import sim.util.gui.DisclosurePanel;
import sim.util.gui.LabelledList;
import sim.util.gui.NumberTextField;
import sim.util.media.chart.ChartGenerator;
import sim.util.media.chart.DataCuller;
import sim.util.media.chart.MinGapDataCuller;
import sim.util.media.chart.SeriesAttributes;
import sim.util.media.chart.TimeSeriesAttributes;
import sim.util.media.chart.XYChartGenerator;

public class TimeSeriesChartGenerator
extends XYChartGenerator {
    JCheckBox useCullingCheckBox;
    NumberTextField maxPointsPerSeriesTextField;
    DataCuller dataCuller;

    @Override
    public void removeSeries(int index) {
        super.removeSeries(index);
        XYSeriesCollection xysc = (XYSeriesCollection)this.getSeriesDataset();
        xysc.removeSeries(index);
    }

    @Override
    public void moveSeries(int index, boolean up) {
        super.moveSeries(index, up);
        if (index > 0 && up || index < this.getSeriesCount() - 1 && !up) {
            XYSeriesCollection xysc = (XYSeriesCollection)this.getSeriesDataset();
            ArrayList items = new ArrayList(xysc.getSeries());
            xysc.removeAllSeries();
            int delta = up ? -1 : 1;
            items.add(index + delta, items.remove(index));
            int i = 0;
            while (i < items.size()) {
                xysc.addSeries((XYSeries)items.get(i));
                ++i;
            }
        }
    }

    public SeriesAttributes addSeries(XYSeries series, SeriesChangeListener stopper) {
        XYSeriesCollection xysc = (XYSeriesCollection)this.getSeriesDataset();
        int i = xysc.getSeriesCount();
        xysc.addSeries(series);
        TimeSeriesAttributes csa = new TimeSeriesAttributes((ChartGenerator)this, series, i, stopper);
        this.seriesAttributes.add(csa);
        this.revalidate();
        return csa;
    }

    @Override
    protected void buildChart() {
        XYSeriesCollection collection = new XYSeriesCollection();
        this.chart = ChartFactory.createXYLineChart((String)"Untitled Chart", (String)"Untitled X Axis", (String)"Untitled Y Axis", (XYDataset)collection, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        ((XYLineAndShapeRenderer)((XYPlot)this.chart.getPlot()).getRenderer()).setDrawSeriesLineAsPath(true);
        this.chart.setAntiAlias(true);
        this.chartPanel = this.buildChartPanel(this.chart);
        this.setChartPanel(this.chartPanel);
        this.setSeriesDataset((Dataset)collection);
    }

    public DataCuller getDataCuller() {
        return this.dataCuller;
    }

    public void setDataCuller(DataCuller dataCuller) {
        this.dataCuller = dataCuller;
    }

    public TimeSeriesChartGenerator() {
        LabelledList globalAttribList = (LabelledList)((DisclosurePanel)this.getGlobalAttribute(-2)).getDisclosedComponent();
        this.useCullingCheckBox = new JCheckBox();
        globalAttribList.add((Component)new JLabel("Cull Data"), (Component)this.useCullingCheckBox);
        this.maxPointsPerSeriesTextField = new NumberTextField(1000.0){

            @Override
            public double newValue(double val) {
                int max = (int)val;
                if (val < 2.0) {
                    return (int)this.getValue();
                }
                TimeSeriesChartGenerator.this.dataCuller = new MinGapDataCuller(max);
                return max;
            }
        };
        this.useCullingCheckBox.setSelected(true);
        globalAttribList.add((Component)new JLabel("... Over"), (Component)this.maxPointsPerSeriesTextField);
        this.maxPointsPerSeriesTextField.setToolTipText("The maximum number of data points in a series before data culling gets triggered.");
        this.dataCuller = new MinGapDataCuller((int)this.maxPointsPerSeriesTextField.getValue());
        this.useCullingCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (TimeSeriesChartGenerator.this.useCullingCheckBox.isSelected()) {
                    TimeSeriesChartGenerator.this.maxPointsPerSeriesTextField.setEnabled(true);
                    int maxPoints = (int)TimeSeriesChartGenerator.this.maxPointsPerSeriesTextField.getValue();
                    TimeSeriesChartGenerator.this.dataCuller = new MinGapDataCuller(maxPoints);
                } else {
                    TimeSeriesChartGenerator.this.maxPointsPerSeriesTextField.setEnabled(false);
                    TimeSeriesChartGenerator.this.dataCuller = null;
                }
            }
        });
    }
}

