/*
 * Decompiled with CFR 0.152.
 */
package sim.util.media.chart;

import java.awt.Color;
import java.awt.Paint;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.SwingUtilities;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.plot.MultiplePiePlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.SeriesChangeListener;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.TableOrder;
import sim.util.media.chart.ChartGenerator;
import sim.util.media.chart.PieChartSeriesAttributes;
import sim.util.media.chart.SeriesAttributes;

public class PieChartGenerator
extends ChartGenerator {
    public static final int MAXIMUM_PIE_CHART_ITEMS = 20;
    final DefaultCategoryDataset emptyDataset = new DefaultCategoryDataset();

    @Override
    public void removeSeries(int index) {
        super.removeSeries(index);
        this.update();
    }

    @Override
    public void moveSeries(int index, boolean up) {
        super.moveSeries(index, up);
        this.update();
    }

    @Override
    public Dataset getSeriesDataset() {
        return ((MultiplePiePlot)this.chart.getPlot()).getDataset();
    }

    @Override
    public void setSeriesDataset(Dataset obj) {
        if (((CategoryDataset)obj).getRowCount() > 20) {
            ((MultiplePiePlot)this.chart.getPlot()).setDataset((CategoryDataset)this.emptyDataset);
            this.setInvalidChartTitle("[[ Dataset has too many items. ]]");
        } else {
            ((MultiplePiePlot)this.chart.getPlot()).setDataset((CategoryDataset)((DefaultCategoryDataset)obj));
            if (this.invalidChartTitle != null) {
                this.setInvalidChartTitle(null);
            }
        }
    }

    public int getProspectiveSeriesCount(Object[] objs) {
        HashMap map = this.convertIntoAmountsAndLabels(objs);
        String[] labels = this.revisedLabels(map);
        return labels.length;
    }

    @Override
    public int getSeriesCount() {
        SeriesAttributes[] sa = this.getSeriesAttributes();
        return sa.length;
    }

    @Override
    protected void buildChart() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        this.chart = ChartFactory.createMultiplePieChart((String)"Untitled Chart", (CategoryDataset)dataset, (TableOrder)TableOrder.BY_COLUMN, (boolean)false, (boolean)true, (boolean)false);
        this.chart.setAntiAlias(true);
        this.chartPanel = this.buildChartPanel(this.chart);
        this.setChartPanel(this.chartPanel);
        JFreeChart baseChart = ((MultiplePiePlot)this.chart.getPlot()).getPieChart();
        PiePlot base = (PiePlot)baseChart.getPlot();
        base.setIgnoreZeroValues(true);
        base.setLabelOutlinePaint((Paint)Color.WHITE);
        base.setLabelShadowPaint((Paint)Color.WHITE);
        base.setMaximumLabelWidth(0.25);
        base.setInteriorGap(0.0);
        base.setLabelBackgroundPaint((Paint)Color.WHITE);
        base.setOutlinePaint(null);
        base.setBackgroundPaint(null);
        base.setShadowPaint(null);
        base.setSimpleLabels(false);
        StandardChartTheme theme = new StandardChartTheme("Hi");
        TextTitle title = new TextTitle("Whatever", theme.getLargeFont());
        title.setPaint(theme.getAxisLabelPaint());
        title.setPosition(RectangleEdge.BOTTOM);
        baseChart.setTitle(title);
        this.setSeriesDataset((Dataset)dataset);
    }

    @Override
    protected void update() {
        SeriesAttributes[] sa = this.getSeriesAttributes();
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        int i = 0;
        while (i < sa.length) {
            if (sa[i].isPlotVisible()) {
                PieChartSeriesAttributes attributes = (PieChartSeriesAttributes)sa[i];
                double[] values = attributes.getValues();
                String[] labels = attributes.getLabels();
                UniqueString seriesName = new UniqueString(attributes.getSeriesName());
                int j = 0;
                while (j < values.length) {
                    dataset.addValue(values[j], (Comparable)((Object)labels[j]), (Comparable)seriesName);
                    ++j;
                }
            }
            ++i;
        }
        this.setSeriesDataset((Dataset)dataset);
    }

    SeriesAttributes addSeries(double[] amounts, String[] labels, String name, SeriesChangeListener stopper) {
        int i = this.getSeriesCount();
        PieChartSeriesAttributes csa = new PieChartSeriesAttributes(this, name, i, amounts, labels, stopper);
        this.seriesAttributes.add(csa);
        this.revalidate();
        this.update();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PieChartGenerator.this.update();
            }
        });
        return csa;
    }

    public SeriesAttributes addSeries(Object[] objs, String name, SeriesChangeListener stopper) {
        HashMap map = this.convertIntoAmountsAndLabels(objs);
        String[] labels = this.revisedLabels(map);
        double[] amounts = this.amounts(map, labels);
        return this.addSeries(amounts, labels, name, stopper);
    }

    HashMap convertIntoAmountsAndLabels(Object[] objs) {
        HashMap<String, Double> map = new HashMap<String, Double>();
        int i = 0;
        while (i < objs.length) {
            String label = "null";
            if (objs[i] != null) {
                label = objs[i].toString();
            }
            if (map.containsKey(label)) {
                map.put(label, new Double((Double)map.get(label) + 1.0));
            } else {
                map.put(label, new Double(1.0));
            }
            ++i;
        }
        return map;
    }

    String[] revisedLabels(HashMap map) {
        Object[] labels = new String[map.size()];
        labels = map.keySet().toArray(labels);
        Arrays.sort(labels);
        return labels;
    }

    double[] amounts(HashMap map, String[] revisedLabels) {
        double[] amounts = new double[map.size()];
        int i = 0;
        while (i < amounts.length) {
            amounts[i] = (Double)map.get(revisedLabels[i]);
            ++i;
        }
        return amounts;
    }

    public void updateSeries(int index, Object[] objs) {
        if (index < 0) {
            return;
        }
        if (index >= this.getNumSeriesAttributes()) {
            return;
        }
        HashMap map = this.convertIntoAmountsAndLabels(objs);
        String[] labels = this.revisedLabels(map);
        double[] amounts = this.amounts(map, labels);
        this.updateSeries(index, amounts, labels);
    }

    void updateSeries(int index, double[] amounts, String[] labels) {
        if (index < 0) {
            return;
        }
        if (index >= this.getNumSeriesAttributes()) {
            return;
        }
        PieChartSeriesAttributes hsa = (PieChartSeriesAttributes)this.getSeriesAttribute(index);
        hsa.setValues(amounts);
        hsa.setLabels(labels);
    }

    public class UniqueString
    implements Comparable {
        String string;

        public UniqueString(String str) {
            this.string = str;
        }

        public boolean equals(Object obj) {
            return obj == this;
        }

        public int compareTo(Object obj) {
            if (obj == this) {
                return 0;
            }
            if (obj == null) {
                throw new NullPointerException();
            }
            if (!(obj instanceof UniqueString)) {
                return -1;
            }
            UniqueString us = (UniqueString)obj;
            if (us.string.equals(this.string)) {
                if (System.identityHashCode(this) > System.identityHashCode(us)) {
                    return 1;
                }
                return -1;
            }
            return us.string.compareTo(this.string);
        }

        public String toString() {
            return this.string;
        }
    }
}

