/*
 * Decompiled with CFR 0.152.
 */
package sim.util.media;

import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.jfree.chart.JFreeChart;

public class PDFEncoder {
    public static void generatePDF(Component component, File file) {
        int width = component.getWidth();
        int height = component.getHeight();
        try {
            Document document = new Document(new Rectangle((float)width, (float)height));
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(file));
            document.addAuthor("MASON");
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            PdfTemplate tp = cb.createTemplate((float)width, (float)height);
            Graphics2D g2 = tp.createGraphics((float)width, (float)height, (FontMapper)new DefaultFontMapper());
            component.paint(g2);
            g2.dispose();
            cb.addTemplate(tp, 0.0f, 0.0f);
            document.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void generatePDF(JFreeChart chart, int width, int height, File file) {
        try {
            Document document = new Document(new Rectangle((float)width, (float)height));
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(file));
            document.addAuthor("MASON");
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            PdfTemplate tp = cb.createTemplate((float)width, (float)height);
            Graphics2D g2 = tp.createGraphics((float)width, (float)height, (FontMapper)new DefaultFontMapper());
            Rectangle2D.Double rectangle2D = new Rectangle2D.Double(0.0, 0.0, width, height);
            chart.draw(g2, (Rectangle2D)rectangle2D);
            g2.dispose();
            cb.addTemplate(tp, 0.0f, 0.0f);
            document.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

