/*
 * Decompiled with CFR 0.152.
 */
package sim.util.gui;

import java.awt.Color;
import sim.util.Bag;
import sim.util.gui.ColorMap;

public class SimpleColorMap
implements ColorMap {
    final Color clearColor = new Color(0, 0, 0, 0);
    static final int COLOR_DISCRETIZATION = 257;
    int minRed = 0;
    int minBlue = 0;
    int minGreen = 0;
    int minAlpha = 0;
    int maxRed = 0;
    int maxBlue = 0;
    int maxGreen = 0;
    int maxAlpha = 0;
    double maxLevel = 0.0;
    double minLevel = 0.0;
    Color minColor = this.clearColor;
    Color maxColor = this.clearColor;
    public Color[] colors;
    Bag[] colorCache = new Bag[257];

    public SimpleColorMap() {
        this.setLevels(0.0, 1.0, Color.black, Color.white);
    }

    public SimpleColorMap(double minLevel, double maxLevel, Color minColor, Color maxColor) {
        this.setLevels(minLevel, maxLevel, minColor, maxColor);
    }

    public SimpleColorMap(Color[] colorTable) {
        this.setColorTable(colorTable);
    }

    public SimpleColorMap(Color[] colorTable, double minLevel, double maxLevel, Color minColor, Color maxColor) {
        this.setColorTable(colorTable);
        this.setLevels(minLevel, maxLevel, minColor, maxColor);
    }

    public Color[] setColorTable(Color[] colorTable) {
        Color[] retval = this.colors;
        this.colors = colorTable;
        return retval;
    }

    public double filterLevel(double level) {
        return level;
    }

    public void setLevels(double minLevel, double maxLevel, Color minColor, Color maxColor) {
        if (maxLevel < minLevel) {
            throw new RuntimeException("maxLevel cannot be less than minLevel");
        }
        this.minRed = minColor.getRed();
        this.minGreen = minColor.getGreen();
        this.minBlue = minColor.getBlue();
        this.minAlpha = minColor.getAlpha();
        this.maxRed = maxColor.getRed();
        this.maxGreen = maxColor.getGreen();
        this.maxBlue = maxColor.getBlue();
        this.maxAlpha = maxColor.getAlpha();
        this.maxLevel = maxLevel;
        this.minLevel = minLevel;
        this.minColor = minColor;
        this.maxColor = maxColor;
        int x = 0;
        while (x < 257) {
            this.colorCache[x] = new Bag();
            ++x;
        }
    }

    @Override
    public Color getColor(double level) {
        int alpha;
        if (this.colors != null && level >= 0.0 && level < (double)this.colors.length) {
            return this.colors[(int)level];
        }
        double minLevel = this.minLevel;
        double maxLevel = this.maxLevel;
        if (level >= maxLevel) {
            return this.maxColor;
        }
        if (level <= minLevel) {
            return this.minColor;
        }
        double interval = maxLevel - minLevel;
        if ((level = this.filterLevel((level - minLevel) / interval) * interval + minLevel) == minLevel) {
            return this.minColor;
        }
        if (level == maxLevel) {
            return this.maxColor;
        }
        double interpolation = (level - minLevel) / (maxLevel - minLevel);
        int n = alpha = this.maxAlpha == this.minAlpha ? this.minAlpha : (int)(interpolation * (double)(this.maxAlpha - this.minAlpha + 1) + (double)this.minAlpha);
        if (alpha == 0) {
            return this.clearColor;
        }
        int red = this.maxRed == this.minRed ? this.minRed : (int)(interpolation * (double)(this.maxRed - this.minRed + 1) + (double)this.minRed);
        int green = this.maxGreen == this.minGreen ? this.minGreen : (int)(interpolation * (double)(this.maxGreen - this.minGreen + 1) + (double)this.minGreen);
        int blue = this.maxBlue == this.minBlue ? this.minBlue : (int)(interpolation * (double)(this.maxBlue - this.minBlue + 1) + (double)this.minBlue);
        int rgb = alpha << 24 | red << 16 | green << 8 | blue;
        Bag colors = this.colorCache[(int)(interpolation * 256.0)];
        int x = 0;
        while (x < colors.numObjs) {
            Color c = (Color)colors.objs[x];
            if (c.getRGB() == rgb) {
                return c;
            }
            ++x;
        }
        Color c = new Color(rgb, alpha != 0);
        colors.add(c);
        return c;
    }

    @Override
    public int getAlpha(double level) {
        if (this.colors != null && level >= 0.0 && level < (double)this.colors.length) {
            return this.colors[(int)level].getAlpha();
        }
        double minLevel = this.minLevel;
        double maxLevel = this.maxLevel;
        if (level >= maxLevel) {
            return this.maxColor.getAlpha();
        }
        if (level <= minLevel) {
            return this.minColor.getAlpha();
        }
        double interval = maxLevel - minLevel;
        level = this.filterLevel((level - minLevel) / interval) * interval + minLevel;
        double interpolation = (level - minLevel) / (maxLevel - minLevel);
        int maxAlpha = this.maxAlpha;
        int minAlpha = this.minAlpha;
        return maxAlpha == minAlpha ? minAlpha : (int)(interpolation * (double)(maxAlpha - minAlpha) + (double)minAlpha);
    }

    @Override
    public int getRGB(double level) {
        int alpha;
        if (this.colors != null && level >= 0.0 && level < (double)this.colors.length) {
            return this.colors[(int)level].getRGB();
        }
        double minLevel = this.minLevel;
        double maxLevel = this.maxLevel;
        if (level >= maxLevel) {
            return this.maxColor.getRGB();
        }
        if (level <= minLevel) {
            return this.minColor.getRGB();
        }
        double interval = maxLevel - minLevel;
        level = this.filterLevel((level - minLevel) / interval) * interval + minLevel;
        double interpolation = (level - minLevel) / (maxLevel - minLevel);
        int maxAlpha = this.maxAlpha;
        int minAlpha = this.minAlpha;
        int n = alpha = maxAlpha == minAlpha ? minAlpha : (int)(interpolation * (double)(maxAlpha - minAlpha) + (double)minAlpha);
        if (alpha == 0) {
            return 0;
        }
        int maxRed = this.maxRed;
        int minRed = this.minRed;
        int maxGreen = this.maxGreen;
        int minGreen = this.minGreen;
        int maxBlue = this.maxBlue;
        int minBlue = this.minBlue;
        int red = maxRed == minRed ? minRed : (int)(interpolation * (double)(maxRed - minRed) + (double)minRed);
        int green = maxGreen == minGreen ? minGreen : (int)(interpolation * (double)(maxGreen - minGreen) + (double)minGreen);
        int blue = maxBlue == minBlue ? minBlue : (int)(interpolation * (double)(maxBlue - minBlue) + (double)minBlue);
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    @Override
    public boolean validLevel(double value) {
        if (this.colors != null && value >= 0.0 && value < (double)this.colors.length) {
            return true;
        }
        return value <= this.maxLevel && value >= this.minLevel;
    }

    @Override
    public double defaultValue() {
        if (this.colors != null) {
            return 0.0;
        }
        return this.minLevel;
    }
}

