/*
 * Decompiled with CFR 0.152.
 */
package sim.util.distribution;

import ec.util.MersenneTwisterFast;
import sim.util.distribution.AbstractContinousDistribution;

public class VonMises
extends AbstractContinousDistribution {
    private static final long serialVersionUID = 1L;
    protected double my_k;
    private double k_set = -1.0;
    private double tau;
    private double rho;
    private double r;

    public VonMises(double freedom, MersenneTwisterFast randomGenerator) {
        this.setRandomGenerator(randomGenerator);
        this.setState(freedom);
    }

    @Override
    public double nextDouble() {
        return this.nextDouble(this.my_k);
    }

    public double nextDouble(double k) {
        double v;
        double u;
        double z;
        double w;
        double c;
        if (k <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (this.k_set != k) {
            this.tau = 1.0 + Math.sqrt(1.0 + 4.0 * k * k);
            this.rho = (this.tau - Math.sqrt(2.0 * this.tau)) / (2.0 * k);
            this.r = (1.0 + this.rho * this.rho) / (2.0 * this.rho);
            this.k_set = k;
        }
        do {
            u = this.randomGenerator.nextDouble();
            v = this.randomGenerator.nextDouble();
        } while ((c = k * (this.r - (w = (1.0 + this.r * (z = Math.cos(Math.PI * u))) / (this.r + z)))) * (2.0 - c) < v && Math.log(c / v) + 1.0 < c);
        return this.randomGenerator.nextDouble() > 0.5 ? Math.acos(w) : -Math.acos(w);
    }

    public void setState(double k) {
        if (k <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.my_k = k;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "(" + this.my_k + ")";
    }
}

