/*
 * Decompiled with CFR 0.152.
 */
package sim.util.distribution;

import ec.util.MersenneTwisterFast;
import sim.util.distribution.AbstractContinousDistribution;

public class Logarithmic
extends AbstractContinousDistribution {
    private static final long serialVersionUID = 1L;
    protected double my_p;
    private double t;
    private double h;
    private double a_prev = -1.0;

    public Logarithmic(double p, MersenneTwisterFast randomGenerator) {
        this.setRandomGenerator(randomGenerator);
        this.setState(p);
    }

    @Override
    public double nextDouble() {
        return this.nextDouble(this.my_p);
    }

    public double nextDouble(double a) {
        if (a != this.a_prev) {
            this.a_prev = a;
            if (a < 0.97) {
                this.t = -a / Math.log(1.0 - a);
            } else {
                this.h = Math.log(1.0 - a);
            }
        }
        double u = this.randomGenerator.nextDouble();
        if (a < 0.97) {
            int k = 1;
            double p = this.t;
            while (u > p) {
                u -= p;
                p *= a * ((double)(++k) - 1.0) / (double)k;
            }
            return k;
        }
        if (u > a) {
            return 1.0;
        }
        double v = u = this.randomGenerator.nextDouble();
        double q = 1.0 - Math.exp(v * this.h);
        if (u <= q * q) {
            int k = (int)(1.0 + Math.log(u) / Math.log(q));
            return k;
        }
        if (u > q) {
            return 1.0;
        }
        return 2.0;
    }

    public void setState(double p) {
        this.my_p = p;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "(" + this.my_p + ")";
    }
}

