/*
 * Decompiled with CFR 0.152.
 */
package sim.util.distribution;

import ec.util.MersenneTwisterFast;
import sim.util.distribution.AbstractContinousDistribution;

public class ExponentialPower
extends AbstractContinousDistribution {
    private static final long serialVersionUID = 1L;
    protected double tau;
    private double s;
    private double sm1;
    private double tau_set = -1.0;

    public ExponentialPower(double tau, MersenneTwisterFast randomGenerator) {
        this.setRandomGenerator(randomGenerator);
        this.setState(tau);
    }

    @Override
    public double nextDouble() {
        return this.nextDouble(this.tau);
    }

    public double nextDouble(double tau) {
        double u;
        double x;
        double v;
        if (tau != this.tau_set) {
            this.s = 1.0 / tau;
            this.sm1 = 1.0 - this.s;
            this.tau_set = tau;
        }
        do {
            u = this.randomGenerator.nextDouble();
            u = 2.0 * u - 1.0;
            double u1 = Math.abs(u);
            v = this.randomGenerator.nextDouble();
            if (u1 <= this.sm1) {
                x = u1;
                continue;
            }
            double y = tau * (1.0 - u1);
            x = this.sm1 - this.s * Math.log(y);
            v *= y;
        } while (Math.log(v) > -Math.exp(Math.log(x) * tau));
        if (u < 0.0) {
            return x;
        }
        return -x;
    }

    public void setState(double tau) {
        if (tau < 1.0) {
            throw new IllegalArgumentException();
        }
        this.tau = tau;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "(" + this.tau + ")";
    }
}

