/*
 * Decompiled with CFR 0.152.
 */
package sim.util;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.Serializable;
import sim.util.Double2D;
import sim.util.Int2D;
import sim.util.MutableInt2D;

public final class MutableDouble2D
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public double x;
    public double y;
    static final double infinity = Double.POSITIVE_INFINITY;

    public MutableDouble2D() {
        this.x = 0.0;
        this.y = 0.0;
    }

    public MutableDouble2D(Int2D p) {
        this.x = p.x;
        this.y = p.y;
    }

    public MutableDouble2D(MutableInt2D p) {
        this.x = p.x;
        this.y = p.y;
    }

    public MutableDouble2D(MutableDouble2D p) {
        this.x = p.x;
        this.y = p.y;
    }

    public MutableDouble2D(Double2D p) {
        this.x = p.x;
        this.y = p.y;
    }

    public MutableDouble2D(Point p) {
        this.x = p.x;
        this.y = p.y;
    }

    public MutableDouble2D(Point2D.Double p) {
        this.x = p.x;
        this.y = p.y;
    }

    public MutableDouble2D(Point2D.Float p) {
        this.x = p.x;
        this.y = p.y;
    }

    public MutableDouble2D(Point2D p) {
        this.x = p.getX();
        this.y = p.getY();
    }

    public MutableDouble2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final void setX(double val) {
        this.x = val;
    }

    public final void setY(double val) {
        this.y = val;
    }

    public final void setTo(double bx, double by) {
        this.x = bx;
        this.y = by;
    }

    public final void setTo(Int2D b) {
        this.x = b.x;
        this.y = b.y;
    }

    public final void setTo(Double2D b) {
        this.x = b.x;
        this.y = b.y;
    }

    public final void setTo(MutableInt2D b) {
        this.x = b.x;
        this.y = b.y;
    }

    public final void setTo(MutableDouble2D b) {
        this.x = b.x;
        this.y = b.y;
    }

    public String toString() {
        return "MutableDouble2D[" + this.x + "," + this.y + "]";
    }

    public String toCoordinates() {
        return "(" + this.x + ", " + this.y + ")";
    }

    public Point2D.Double toPoint2D() {
        return new Point2D.Double(this.x, this.y);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public final int hashCode() {
        double x = this.x;
        double y = this.y;
        if (x == -0.0) {
            x = 0.0;
        }
        if (y == -0.0) {
            y = 0.0;
        }
        if ((double)((int)x) == x && (double)((int)y) == y) {
            int y_ = (int)y;
            int x_ = (int)x;
            y_ += ~(y_ << 15);
            y_ ^= y_ >>> 10;
            y_ += y_ << 3;
            y_ ^= y_ >>> 6;
            y_ += ~(y_ << 11);
            y_ ^= y_ >>> 16;
            return x_ ^ y_;
        }
        long key = Double.doubleToLongBits(y);
        key += key << 32 ^ 0xFFFFFFFFFFFFFFFFL;
        key ^= key >>> 22;
        key += key << 13 ^ 0xFFFFFFFFFFFFFFFFL;
        key ^= key >>> 8;
        key += key << 3;
        key ^= key >>> 15;
        key += key << 27 ^ 0xFFFFFFFFFFFFFFFFL;
        key ^= key >>> 31;
        return (int)((key ^= Double.doubleToLongBits(x)) ^ key >> 32);
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Double2D) {
            Double2D other = (Double2D)obj;
            return (this.x == other.x || Double.isNaN(this.x) && Double.isNaN(other.x)) && (this.y == other.y || Double.isNaN(this.y) && Double.isNaN(other.y));
        }
        if (obj instanceof MutableDouble2D) {
            MutableDouble2D other = (MutableDouble2D)obj;
            return (this.x == other.x || Double.isNaN(this.x) && Double.isNaN(other.x)) && (this.y == other.y || Double.isNaN(this.y) && Double.isNaN(other.y));
        }
        if (obj instanceof Int2D) {
            Int2D other = (Int2D)obj;
            return (double)other.x == this.x && (double)other.y == this.y;
        }
        if (obj instanceof MutableInt2D) {
            MutableInt2D other = (MutableInt2D)obj;
            return (double)other.x == this.x && (double)other.y == this.y;
        }
        return false;
    }

    public double distance(double x, double y) {
        double dx = this.x - x;
        double dy = this.y - y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double distance(MutableDouble2D p) {
        double dx = this.x - p.x;
        double dy = this.y - p.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double distance(Double2D p) {
        double dx = this.x - p.x;
        double dy = this.y - p.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double distance(Int2D p) {
        double dx = this.x - (double)p.x;
        double dy = this.y - (double)p.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double distance(MutableInt2D p) {
        double dx = this.x - (double)p.x;
        double dy = this.y - (double)p.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double distance(Point2D p) {
        double dx = this.x - p.getX();
        double dy = this.y - p.getY();
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double distanceSq(double x, double y) {
        double dx = this.x - x;
        double dy = this.y - y;
        return dx * dx + dy * dy;
    }

    public double distanceSq(Double2D p) {
        double dx = this.x - p.x;
        double dy = this.y - p.y;
        return dx * dx + dy * dy;
    }

    public double distanceSq(MutableDouble2D p) {
        double dx = this.x - p.x;
        double dy = this.y - p.y;
        return dx * dx + dy * dy;
    }

    public double distanceSq(Int2D p) {
        double dx = this.x - (double)p.x;
        double dy = this.y - (double)p.y;
        return dx * dx + dy * dy;
    }

    public double distanceSq(MutableInt2D p) {
        double dx = this.x - (double)p.x;
        double dy = this.y - (double)p.y;
        return dx * dx + dy * dy;
    }

    public double distanceSq(Point2D p) {
        double dx = this.x - p.getX();
        double dy = this.y - p.getY();
        return dx * dx + dy * dy;
    }

    public double manhattanDistance(double x, double y) {
        double dx = Math.abs(this.x - x);
        double dy = Math.abs(this.y - y);
        return dx + dy;
    }

    public double manhattanDistance(Double2D p) {
        double dx = Math.abs(this.x - p.x);
        double dy = Math.abs(this.y - p.y);
        return dx + dy;
    }

    public double manhattanDistance(Int2D p) {
        double dx = Math.abs(this.x - (double)p.x);
        double dy = Math.abs(this.y - (double)p.y);
        return dx + dy;
    }

    public double manhattanDistance(MutableDouble2D p) {
        double dx = Math.abs(this.x - p.x);
        double dy = Math.abs(this.y - p.y);
        return dx + dy;
    }

    public double manhattanDistance(MutableInt2D p) {
        double dx = Math.abs(this.x - (double)p.x);
        double dy = Math.abs(this.y - (double)p.y);
        return dx + dy;
    }

    public double manhattanDistance(Point2D p) {
        double dx = Math.abs(this.x - p.getX());
        double dy = Math.abs(this.y - p.getY());
        return dx + dy;
    }

    public final MutableDouble2D addIn(Double2D other) {
        this.x = other.x + this.x;
        this.y = other.y + this.y;
        return this;
    }

    public final MutableDouble2D addIn(MutableDouble2D other) {
        this.x = other.x + this.x;
        this.y = other.y + this.y;
        return this;
    }

    public final MutableDouble2D addIn(double x, double y) {
        this.x += x;
        this.y += y;
        return this;
    }

    public final MutableDouble2D add(MutableDouble2D other1, MutableDouble2D other2) {
        this.x = other1.x + other2.x;
        this.y = other1.y + other2.y;
        return this;
    }

    public final MutableDouble2D add(Double2D other1, MutableDouble2D other2) {
        this.x = other1.x + other2.x;
        this.y = other1.y + other2.y;
        return this;
    }

    public final MutableDouble2D add(MutableDouble2D other1, Double2D other2) {
        this.x = other1.x + other2.x;
        this.y = other1.y + other2.y;
        return this;
    }

    public final MutableDouble2D dup() {
        return new MutableDouble2D(this);
    }

    public final MutableDouble2D subtractIn(Double2D other) {
        this.x -= other.x;
        this.y -= other.y;
        return this;
    }

    public final MutableDouble2D subtractIn(MutableDouble2D other) {
        this.x -= other.x;
        this.y -= other.y;
        return this;
    }

    public final MutableDouble2D subtract(MutableDouble2D other1, MutableDouble2D other2) {
        this.x = other1.x - other2.x;
        this.y = other1.y - other2.y;
        return this;
    }

    public final MutableDouble2D subtract(Double2D other1, MutableDouble2D other2) {
        this.x = other1.x - other2.x;
        this.y = other1.y - other2.y;
        return this;
    }

    public final MutableDouble2D subtract(MutableDouble2D other1, Double2D other2) {
        this.x = other1.x - other2.x;
        this.y = other1.y - other2.y;
        return this;
    }

    public final double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public final double lengthSq() {
        return this.x * this.x + this.y * this.y;
    }

    public final double angle() {
        return Math.atan2(this.y, this.x);
    }

    public final MutableDouble2D multiplyIn(double val) {
        this.x *= val;
        this.y *= val;
        return this;
    }

    public final MutableDouble2D multiply(MutableDouble2D other, double val) {
        this.x = other.x * val;
        this.y = other.y * val;
        return this;
    }

    public final MutableDouble2D multiply(Double2D other, double val) {
        this.x = other.x * val;
        this.y = other.y * val;
        return this;
    }

    public final MutableDouble2D normalize() {
        double invertedlen = 1.0 / Math.sqrt(this.x * this.x + this.y * this.y);
        if (invertedlen == Double.POSITIVE_INFINITY || invertedlen == Double.NEGATIVE_INFINITY || invertedlen == 0.0 || invertedlen != invertedlen) {
            throw new ArithmeticException(this + " length is " + Math.sqrt(this.x * this.x + this.y * this.y) + ", cannot normalize");
        }
        this.x *= invertedlen;
        this.y *= invertedlen;
        return this;
    }

    public final MutableDouble2D setLength(double val) {
        return this.resize(val);
    }

    public final MutableDouble2D resize(double val) {
        if (val < 0.0) {
            throw new IllegalArgumentException("The argument to MutableDouble2D.setLength(...) must be zero or positive");
        }
        if (val == 0.0) {
            this.y = 0.0;
            this.x = 0.0;
        } else {
            double len = Math.sqrt(this.x * this.x + this.y * this.y);
            if (len != len || len == Double.POSITIVE_INFINITY || len == Double.NEGATIVE_INFINITY || len == 0.0) {
                throw new ArithmeticException(this + " length is " + len + " cannot change its length");
            }
            double invertedlen = val / len;
            this.x *= invertedlen;
            this.y *= invertedlen;
        }
        return this;
    }

    public final MutableDouble2D rotate(double theta) {
        double sinTheta = Math.sin(theta);
        double cosTheta = Math.cos(theta);
        double x = this.x;
        double y = this.y;
        this.x = cosTheta * x + -sinTheta * y;
        this.y = sinTheta * x + cosTheta * y;
        return this;
    }

    public final double dot(MutableDouble2D other) {
        return other.x * this.x + other.y * this.y;
    }

    public double perpDot(MutableDouble2D other) {
        return -this.y * other.x + this.x * other.y;
    }

    public final MutableDouble2D zero() {
        this.x = 0.0;
        this.y = 0.0;
        return this;
    }

    public final MutableDouble2D setToMinus(MutableDouble2D b) {
        this.x = -b.x;
        this.y = -b.y;
        return this;
    }

    public final MutableDouble2D negate() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }
}

