/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal3d.simple;

import java.awt.Image;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.OrientedShape3D;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TransformGroup;
import javax.swing.ImageIcon;
import javax.vecmath.Point3f;
import javax.vecmath.TexCoord2f;
import sim.portrayal.LocationWrapper;
import sim.portrayal3d.SimplePortrayal3D;

public class ImagePortrayal3D
extends SimplePortrayal3D {
    Shape3D shape;

    public ImagePortrayal3D(Class c, String resourceName) {
        this(new ImageIcon(c.getResource(resourceName)));
    }

    public ImagePortrayal3D(Class c, String resourceName, boolean oriented, boolean opaque) {
        this(new ImageIcon(c.getResource(resourceName)), oriented, opaque);
    }

    public ImagePortrayal3D(ImageIcon icon) {
        this(icon.getImage());
    }

    public ImagePortrayal3D(ImageIcon icon, boolean oriented, boolean opaque) {
        this(icon.getImage(), oriented, opaque);
    }

    public ImagePortrayal3D(Image image) {
        this(image, true, false);
    }

    public ImagePortrayal3D(Image image, boolean oriented, boolean opaque) {
        float width = image.getWidth(null);
        float height = image.getHeight(null);
        if (width > height) {
            width /= height;
            height = 1.0f;
        } else {
            height /= width;
            width = 1.0f;
        }
        float[] vertices = new float[]{width / 2.0f, -height / 2.0f, 0.0f, width / 2.0f, height / 2.0f, 0.0f, -width / 2.0f, height / 2.0f, 0.0f, -width / 2.0f, -height / 2.0f, 0.0f};
        QuadArray geometry = new QuadArray(4, 33);
        geometry.setCoordinates(0, vertices);
        geometry.setTextureCoordinate(0, 0, new TexCoord2f(1.0f, 1.0f));
        geometry.setTextureCoordinate(0, 1, new TexCoord2f(1.0f, 0.0f));
        geometry.setTextureCoordinate(0, 2, new TexCoord2f(0.0f, 0.0f));
        geometry.setTextureCoordinate(0, 3, new TexCoord2f(0.0f, 1.0f));
        Appearance appearance = ImagePortrayal3D.appearanceForImage(image, opaque);
        PolygonAttributes pa = new PolygonAttributes();
        pa.setCullFace(oriented ? 1 : 0);
        appearance.setPolygonAttributes(pa);
        this.shape = oriented ? new OrientedShape3D((Geometry)geometry, appearance, 1, new Point3f(0.0f, 0.0f, 0.0f)) : new Shape3D((Geometry)geometry, appearance);
    }

    @Override
    public TransformGroup getModel(Object obj, TransformGroup j3dModel) {
        if (j3dModel == null) {
            j3dModel = new TransformGroup();
            j3dModel.setCapability(12);
            Shape3D s = (Shape3D)this.shape.cloneTree(false);
            ImagePortrayal3D.setPickableFlags(s);
            LocationWrapper pickI = new LocationWrapper(obj, null, this.getCurrentFieldPortrayal());
            s.setUserData((Object)pickI);
            j3dModel.addChild((Node)s);
        }
        return j3dModel;
    }
}

