/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal3d.grid;

import com.sun.j3d.utils.picking.PickIntersection;
import com.sun.j3d.utils.picking.PickResult;
import java.awt.Color;
import java.util.BitSet;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Switch;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Vector3f;
import sim.field.grid.AbstractGrid2D;
import sim.field.grid.AbstractGrid3D;
import sim.field.grid.DoubleGrid2D;
import sim.field.grid.DoubleGrid3D;
import sim.field.grid.IntGrid2D;
import sim.field.grid.IntGrid3D;
import sim.portrayal.LocationWrapper;
import sim.portrayal.Portrayal;
import sim.portrayal3d.FieldPortrayal3D;
import sim.portrayal3d.Portrayal3D;
import sim.portrayal3d.SimplePortrayal3D;
import sim.portrayal3d.simple.ValuePortrayal3D;
import sim.util.Int2D;
import sim.util.Int3D;
import sim.util.MutableDouble;
import sim.util.gui.ColorMap;
import sim.util.gui.SimpleColorMap;

public class ValueGridPortrayal3D
extends FieldPortrayal3D {
    String valueName;
    double scale;
    ColorMap map = new SimpleColorMap();
    int width = 0;
    int height = 0;
    int length = 0;
    final MutableDouble valueToPass = new MutableDouble(0.0);
    boolean dirtyScale = false;
    ValuePortrayal3D defaultPortrayal = new ValuePortrayal3D();

    public ColorMap getMap() {
        return this.map;
    }

    public void setMap(ColorMap m) {
        this.map = m;
    }

    public String getValueName() {
        return this.valueName;
    }

    public void setValueName(String name) {
        this.valueName = name;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double val) {
        this.scale = val;
        this.dirtyScale = true;
    }

    @Override
    public Portrayal getDefaultPortrayal() {
        return this.defaultPortrayal;
    }

    @Override
    public void setField(Object field) {
        if (!(field instanceof IntGrid3D || field instanceof DoubleGrid3D || field instanceof IntGrid2D || field instanceof DoubleGrid2D)) {
            throw new RuntimeException("Invalid field for ValueGridPortrayal3D: " + field);
        }
        super.setField(field);
    }

    @Override
    public Object getField() {
        return this.field;
    }

    public ValueGridPortrayal3D() {
        this("Value", 1.0);
    }

    public ValueGridPortrayal3D(String valueName) {
        this(valueName, 1.0);
    }

    public ValueGridPortrayal3D(double s) {
        this("Value", s);
    }

    public ValueGridPortrayal3D(String valueName, double scale) {
        this.valueName = valueName;
        this.scale = scale;
    }

    @Override
    public PolygonAttributes polygonAttributes() {
        return ((Portrayal3D)this.getPortrayalForObject(new ValueWrapper(0.0, (Object)new Int3D(), this))).polygonAttributes();
    }

    public double newValue(int x, int y, int z, double value) {
        if (this.field instanceof IntGrid2D || this.field instanceof IntGrid3D) {
            value = (int)value;
        }
        if (this.map.validLevel(value)) {
            return value;
        }
        if (this.field != null) {
            if (this.field instanceof DoubleGrid3D) {
                return ((DoubleGrid3D)this.field).field[x][y][z];
            }
            if (this.field instanceof IntGrid3D) {
                return ((IntGrid3D)this.field).field[x][y][z];
            }
            if (this.field instanceof DoubleGrid2D) {
                return ((DoubleGrid2D)this.field).field[x][y];
            }
            return ((IntGrid2D)this.field).field[x][y];
        }
        return this.map.defaultValue();
    }

    double gridValue(int x, int y, int z) {
        if (this.field instanceof DoubleGrid3D) {
            return ((DoubleGrid3D)this.field).field[x][y][z];
        }
        if (this.field instanceof IntGrid3D) {
            return ((IntGrid3D)this.field).field[x][y][z];
        }
        if (this.field instanceof DoubleGrid2D) {
            return ((DoubleGrid2D)this.field).field[x][y];
        }
        return ((IntGrid2D)this.field).field[x][y];
    }

    @Override
    public TransformGroup createModel() {
        TransformGroup globalTG = new TransformGroup();
        globalTG.setCapability(12);
        if (this.field == null) {
            return globalTG;
        }
        this.dirtyScale = false;
        Switch localSwitch = new Switch(-3);
        localSwitch.setCapability(17);
        localSwitch.setCapability(18);
        localSwitch.setCapability(12);
        globalTG.addChild((Node)localSwitch);
        this.extractDimensions();
        BitSet childMask = new BitSet(this.width * this.height * this.length);
        Transform3D trans = new Transform3D();
        Portrayal p = this.getPortrayalForObject(new ValueWrapper(0.0, (Object)new Int3D(), this));
        if (!(p instanceof SimplePortrayal3D)) {
            throw new RuntimeException("Unexpected Portrayal " + p + "for object " + this.valueToPass + " -- expected a SimplePortrayal3D");
        }
        SimplePortrayal3D portrayal = (SimplePortrayal3D)p;
        portrayal.setCurrentFieldPortrayal(this);
        int i = 0;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                int z = 0;
                while (z < length) {
                    double value = this.gridValue(x, y, z);
                    TransformGroup tg = portrayal.getModel(new ValueWrapper(0.0, (Object)new Int3D(x, y, z), this), null);
                    tg.setCapability(17);
                    tg.setCapability(18);
                    tg.setCapability(12);
                    trans.setTranslation(new Vector3f((float)x, (float)y, (float)z));
                    trans.setScale(this.scale);
                    tg.setTransform(trans);
                    localSwitch.addChild((Node)tg);
                    if (this.map.getAlpha(value) > 2) {
                        childMask.set(i);
                    } else {
                        childMask.clear(i);
                    }
                    ++i;
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        localSwitch.setChildMask(childMask);
        return globalTG;
    }

    @Override
    public void updateModel(TransformGroup modelTG) {
        if (this.field == null) {
            return;
        }
        this.extractDimensions();
        Switch localSwitch = (Switch)modelTG.getChild(0);
        BitSet childMask = localSwitch.getChildMask();
        Portrayal p = this.getPortrayalForObject(this.valueToPass);
        if (!(p instanceof SimplePortrayal3D)) {
            throw new RuntimeException("Unexpected Portrayal " + p + "for object " + this.valueToPass + " -- expected a SimplePortrayal3D");
        }
        SimplePortrayal3D portrayal = (SimplePortrayal3D)p;
        portrayal.setCurrentFieldPortrayal(this);
        if (this.dirtyScale || this.isDirtyField()) {
            this.reviseScale(localSwitch);
        }
        int i = 0;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                int z = 0;
                while (z < length) {
                    double oldValue;
                    TransformGroup tg = (TransformGroup)localSwitch.getChild(i);
                    Shape3D shape = (Shape3D)tg.getChild(0);
                    ValueWrapper wrapper = (ValueWrapper)shape.getUserData();
                    double value = this.gridValue(x, y, z);
                    if (value != (oldValue = wrapper.lastValue)) {
                        if (this.map.getAlpha(value) > 2) {
                            childMask.set(i);
                            wrapper.lastValue = value;
                            portrayal.getModel(wrapper, tg);
                        } else {
                            childMask.clear(i);
                        }
                    }
                    ++i;
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        localSwitch.setChildMask(childMask);
    }

    void reviseScale(Switch localSwitch) {
        Transform3D trans = new Transform3D();
        int i = 0;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                int z = 0;
                while (z < length) {
                    TransformGroup tg = (TransformGroup)localSwitch.getChild(i);
                    tg.getTransform(trans);
                    trans.setScale(this.scale);
                    tg.setTransform(trans);
                    ++i;
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        this.dirtyScale = false;
    }

    void extractDimensions() {
        if (this.field instanceof IntGrid3D || this.field instanceof DoubleGrid3D) {
            AbstractGrid3D v = (AbstractGrid3D)this.field;
            int _width = v.getWidth();
            int _height = v.getHeight();
            int _length = v.getLength();
            if (this.width != 0 && (_width != this.width || _height != this.height || _length != this.length)) {
                throw new RuntimeException("Cannot presently change the dimensions of a field once it's set in ValueGridPortrayal3D.  Sorry.");
            }
            this.width = _width;
            this.height = _height;
            this.length = _length;
        } else if (this.field instanceof IntGrid2D || this.field instanceof DoubleGrid2D) {
            AbstractGrid2D v = (AbstractGrid2D)this.field;
            int _width = v.getWidth();
            int _height = v.getHeight();
            int _length = 1;
            if (this.width != 0 && (_width != this.width || _height != this.height || _length != this.length)) {
                throw new RuntimeException("Cannot presently change the dimensions of a field once it's set in ValueGridPortrayal3D.  Sorry.");
            }
            this.width = _width;
            this.height = _height;
            this.length = _length;
        } else {
            throw new RuntimeException("Invalid field for ValueGridPortrayal3D: " + this.field);
        }
    }

    @Override
    public LocationWrapper completedWrapper(LocationWrapper w, PickIntersection pi, PickResult pr) {
        return w;
    }

    public Color getColorFor(Object wrapper) {
        return this.getMap().getColor(((ValueWrapper)wrapper).lastValue);
    }

    static class ValueWrapper
    extends LocationWrapper {
        public double lastValue;

        public ValueWrapper(double value, Object location, ValueGridPortrayal3D portrayal) {
            super(new MutableDouble(value), location, portrayal);
            this.lastValue = value;
        }

        @Override
        public Object getObject() {
            Int3D loc = (Int3D)this.location;
            Object field = this.fieldPortrayal.getField();
            MutableDouble val = (MutableDouble)this.object;
            val.val = field instanceof DoubleGrid3D ? ((DoubleGrid3D)field).field[loc.x][loc.y][loc.z] : (field instanceof IntGrid3D ? (double)((IntGrid3D)field).field[loc.x][loc.y][loc.z] : (field instanceof DoubleGrid2D ? ((DoubleGrid2D)field).field[loc.x][loc.y] : (double)((IntGrid2D)field).field[loc.x][loc.y]));
            return val;
        }

        @Override
        public String getLocationName() {
            Int3D loc = (Int3D)this.location;
            Object field = this.fieldPortrayal.getField();
            if (field instanceof DoubleGrid3D || field instanceof IntGrid3D) {
                return loc.toCoordinates();
            }
            return new Int2D(loc.x, loc.y).toCoordinates();
        }
    }
}

