/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.simple;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.SimplePortrayal2D;

public class OvalPortrayal2D
extends SimplePortrayal2D {
    public Paint paint;
    public double scale;
    public boolean filled;
    protected double offset = 0.0;
    transient Ellipse2D.Double preciseEllipse = new Ellipse2D.Double();

    public OvalPortrayal2D() {
        this(Color.gray, 1.0, true);
    }

    public OvalPortrayal2D(Paint paint) {
        this(paint, 1.0, true);
    }

    public OvalPortrayal2D(double scale) {
        this(Color.gray, scale, true);
    }

    public OvalPortrayal2D(Paint paint, double scale) {
        this(paint, scale, true);
    }

    public OvalPortrayal2D(Paint paint, boolean filled) {
        this(paint, 1.0, filled);
    }

    public OvalPortrayal2D(double scale, boolean filled) {
        this(Color.gray, scale, filled);
    }

    public OvalPortrayal2D(Paint paint, double scale, boolean filled) {
        this.paint = paint;
        this.scale = scale;
        this.filled = filled;
    }

    @Override
    public void draw(Object object, Graphics2D graphics, DrawInfo2D info) {
        Rectangle2D.Double draw = info.draw;
        double width = draw.width * this.scale + this.offset;
        double height = draw.height * this.scale + this.offset;
        graphics.setPaint(this.paint);
        if (info.precise) {
            if (this.preciseEllipse == null) {
                this.preciseEllipse = new Ellipse2D.Double();
            }
            this.preciseEllipse.setFrame(info.draw.x - width / 2.0, info.draw.y - height / 2.0, width, height);
            if (this.filled) {
                graphics.fill(this.preciseEllipse);
            } else {
                graphics.draw(this.preciseEllipse);
            }
            return;
        }
        int x = (int)(draw.x - width / 2.0);
        int y = (int)(draw.y - height / 2.0);
        int w = (int)width;
        int h = (int)height;
        if (this.filled) {
            graphics.fillOval(x, y, w, h);
        } else {
            graphics.drawOval(x, y, w, h);
        }
    }

    @Override
    public boolean hitObject(Object object, DrawInfo2D range) {
        if (this.preciseEllipse == null) {
            this.preciseEllipse = new Ellipse2D.Double();
        }
        double SLOP = 1.0;
        double width = range.draw.width * this.scale;
        double height = range.draw.height * this.scale;
        this.preciseEllipse.setFrame(range.draw.x - width / 2.0 - 1.0, range.draw.y - height / 2.0 - 1.0, width + 2.0, height + 2.0);
        return this.preciseEllipse.intersects(range.clip.x, range.clip.y, range.clip.width, range.clip.height);
    }
}

