/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.simple;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import sim.display.GUIState;
import sim.display.Manipulating2D;
import sim.engine.Schedule;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.FieldPortrayal2D;
import sim.portrayal.Inspector;
import sim.portrayal.LocationWrapper;
import sim.portrayal.SimplePortrayal2D;
import sim.util.Double2D;

public class MovablePortrayal2D
extends SimplePortrayal2D {
    public SimplePortrayal2D child;
    Point2D originalMousePosition = null;
    Point2D originalObjectPosition = null;

    public MovablePortrayal2D(SimplePortrayal2D child) {
        this.child = child;
    }

    public SimplePortrayal2D getChild(Object object) {
        if (this.child != null) {
            return this.child;
        }
        if (!(object instanceof SimplePortrayal2D)) {
            throw new RuntimeException("Object provided to MovablePortrayal2D is not a SimplePortrayal2D: " + object);
        }
        return (SimplePortrayal2D)object;
    }

    @Override
    public void draw(Object object, Graphics2D graphics, DrawInfo2D info) {
        this.getChild(object).draw(object, graphics, info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean handleMouseEvent(GUIState guistate, Manipulating2D manipulating, LocationWrapper wrapper, MouseEvent event, DrawInfo2D range, int type) {
        Schedule schedule = guistate.state.schedule;
        synchronized (schedule) {
            int id = event.getID();
            Point2D.Double objPos = ((FieldPortrayal2D)wrapper.getFieldPortrayal()).getObjectPosition(wrapper.getObject(), range);
            if (id == 501 && objPos != null) {
                this.originalMousePosition = event.getPoint();
                this.originalObjectPosition = objPos;
                DrawInfo2D hitRange = new DrawInfo2D(range);
                Double2D scale = ((FieldPortrayal2D)wrapper.getFieldPortrayal()).getScale(range);
                hitRange.draw.x = this.originalObjectPosition.getX();
                hitRange.draw.y = this.originalObjectPosition.getY();
                hitRange.draw.width = scale.x;
                hitRange.draw.height = scale.y;
                hitRange.clip.x = this.originalMousePosition.getX();
                hitRange.clip.y = this.originalMousePosition.getY();
                hitRange.clip.width = 1.0;
                hitRange.clip.height = 1.0;
                if (this.hitObject(wrapper.getObject(), hitRange)) {
                    manipulating.performSelection(wrapper);
                    return true;
                }
                this.originalObjectPosition = null;
                this.originalMousePosition = null;
            } else {
                if (id == 506 && type == 0 && this.originalObjectPosition != null) {
                    Point currentMousePosition = event.getPoint();
                    Point2D.Double d = new Point2D.Double(this.originalObjectPosition.getX() + (((Point2D)currentMousePosition).getX() - this.originalMousePosition.getX()), this.originalObjectPosition.getY() + (((Point2D)currentMousePosition).getY() - this.originalMousePosition.getY()));
                    ((FieldPortrayal2D)wrapper.getFieldPortrayal()).setObjectPosition(wrapper.getObject(), d, range);
                    return true;
                }
                if (id != 502) return this.getChild(wrapper.getObject()).handleMouseEvent(guistate, manipulating, wrapper, event, range, type);
                this.originalMousePosition = null;
                this.originalObjectPosition = null;
            }
            return this.getChild(wrapper.getObject()).handleMouseEvent(guistate, manipulating, wrapper, event, range, type);
        }
    }

    @Override
    public boolean hitObject(Object object, DrawInfo2D range) {
        return this.getChild(object).hitObject(object, range);
    }

    @Override
    public boolean setSelected(LocationWrapper wrapper, boolean selected) {
        return this.getChild(wrapper.getObject()).setSelected(wrapper, selected);
    }

    @Override
    public Inspector getInspector(LocationWrapper wrapper, GUIState state) {
        return this.getChild(wrapper.getObject()).getInspector(wrapper, state);
    }

    @Override
    public String getName(LocationWrapper wrapper) {
        return this.getChild(wrapper.getObject()).getName(wrapper);
    }
}

