/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.inspector;

import sim.field.continuous.Continuous2D;
import sim.portrayal.inspector.StableLocation;
import sim.util.Double2D;

public class StableDouble2D
implements StableLocation {
    public double x = 0.0;
    public double y = 0.0;
    public boolean exists;
    public Continuous2D field;
    public Object object;

    @Override
    public String toString() {
        this.update();
        if (!this.exists) {
            return "Gone";
        }
        return "(" + this.x + ", " + this.y + ")";
    }

    public StableDouble2D(Continuous2D field, Object object) {
        this.field = field;
        this.object = object;
    }

    void update() {
        Double2D pos = null;
        if (this.field != null) {
            pos = this.field.getObjectLocation(this.object);
        }
        if (pos == null) {
            this.exists = false;
        } else {
            this.x = pos.x;
            this.y = pos.y;
            this.exists = true;
        }
    }

    public double getX() {
        this.update();
        return this.x;
    }

    public double getY() {
        this.update();
        return this.y;
    }

    public boolean getExists() {
        this.update();
        return this.exists;
    }

    public void setX(double val) {
        if (this.field != null) {
            this.field.setObjectLocation(this.object, new Double2D(val, this.getY()));
        }
        this.x = val;
        this.exists = true;
    }

    public void setY(double val) {
        if (this.field != null) {
            this.field.setObjectLocation(this.object, new Double2D(this.getX(), val));
        }
        this.y = val;
        this.exists = true;
    }
}

