/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.inspector;

import java.awt.Frame;
import org.jfree.data.general.SeriesChangeEvent;
import org.jfree.data.general.SeriesChangeListener;
import sim.display.GUIState;
import sim.engine.Stoppable;
import sim.portrayal.inspector.ChartingPropertyInspector;
import sim.util.Properties;
import sim.util.media.chart.BarChartGenerator;
import sim.util.media.chart.ChartGenerator;

public class BarChartChartingPropertyInspector
extends ChartingPropertyInspector {
    Object[] previousValues = new Object[0];

    @Override
    protected boolean validChartGenerator(ChartGenerator generator) {
        return generator instanceof BarChartGenerator;
    }

    @Override
    protected boolean includeAggregationMethodAttributes() {
        return false;
    }

    public static String name() {
        return "Make Bar Chart";
    }

    public static Class[] types() {
        return new Class[]{new Object[0].getClass()};
    }

    public BarChartChartingPropertyInspector(Properties properties, int index, Frame parent, GUIState simulation) {
        super(properties, index, parent, simulation);
        this.setupSeriesAttributes(properties, index);
    }

    public BarChartChartingPropertyInspector(Properties properties, int index, GUIState simulation, ChartGenerator generator) {
        super(properties, index, simulation, generator);
        this.setupSeriesAttributes(properties, index);
    }

    private void setupSeriesAttributes(Properties properties, int index) {
        if (this.isValidInspector()) {
            if (this.getGenerator().getNumSeriesAttributes() == 0) {
                this.getGenerator().setTitle(properties.getName(index) + " of " + properties.getObject());
            }
            this.seriesAttributes = ((BarChartGenerator)this.generator).addSeries(this.previousValues, properties.getName(index), new SeriesChangeListener(){

                public void seriesChanged(SeriesChangeEvent event) {
                    BarChartChartingPropertyInspector.this.getStopper().stop();
                }
            });
        }
    }

    @Override
    protected ChartGenerator createNewGenerator() {
        return new BarChartGenerator(){

            @Override
            public void quit() {
                super.quit();
                Stoppable stopper = BarChartChartingPropertyInspector.this.getStopper();
                if (stopper != null) {
                    stopper.stop();
                }
                BarChartChartingPropertyInspector.this.getCharts(BarChartChartingPropertyInspector.this.simulation).remove(this);
            }
        };
    }

    @Override
    public void updateSeries(double time, double lastTime) {
        Object obj = this.properties.getValue(this.index);
        if (obj == null) {
            return;
        }
        Class<?> cls = obj.getClass();
        Object[] vals = this.previousValues;
        Class<?> comp = cls.getComponentType();
        if (comp.equals(Object.class)) {
            Object[] array = (Object[])obj;
            vals = new Object[array.length];
            int i = 0;
            while (i < array.length) {
                vals[i] = array[i];
                ++i;
            }
        }
        boolean same = true;
        if (this.previousValues != null && vals.length == this.previousValues.length) {
            int i = 0;
            while (i < vals.length) {
                if (vals[i] != this.previousValues[i]) {
                    same = false;
                    break;
                }
                ++i;
            }
        } else {
            same = false;
        }
        if (same) {
            return;
        }
        this.previousValues = vals;
        ((BarChartGenerator)this.generator).updateSeries(this.seriesAttributes.getSeriesIndex(), vals);
    }
}

