/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.grid;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import sim.engine.Schedule;
import sim.field.grid.DenseGrid2D;
import sim.field.grid.Grid2D;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.Portrayal;
import sim.portrayal.SimplePortrayal2D;
import sim.portrayal.grid.DenseGridPortrayal2D;
import sim.portrayal.grid.DrawPolicy;
import sim.portrayal.simple.HexagonalPortrayal2D;
import sim.util.Bag;
import sim.util.Double2D;
import sim.util.Int2D;

public class HexaDenseGridPortrayal2D
extends DenseGridPortrayal2D {
    int[] xPoints = new int[6];
    int[] yPoints = new int[6];
    double[] xyC = new double[2];
    double[] xyC_ul = new double[2];
    double[] xyC_up = new double[2];
    double[] xyC_ur = new double[2];
    static final double HEXAGONAL_RATIO = 2.0 / Math.sqrt(3.0);

    static final void getxyC(int x, int y, double xScale, double yScale, double tx, double ty, double[] xyC) {
        xyC[0] = tx + xScale * (1.5 * (double)x + 1.0);
        xyC[1] = ty + yScale * (1.0 + 2.0 * (double)y + (double)(x < 0 ? -x % 2 : x % 2));
    }

    public HexaDenseGridPortrayal2D() {
        this.defaultPortrayal = new HexagonalPortrayal2D();
    }

    public HexaDenseGridPortrayal2D(DrawPolicy policy) {
        super(policy);
        this.defaultPortrayal = new HexagonalPortrayal2D();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double2D getScale(DrawInfo2D info) {
        Schedule schedule = info.gui.state.schedule;
        synchronized (schedule) {
            int maxY;
            int maxX;
            block6: {
                Grid2D field;
                block5: {
                    field = (Grid2D)this.field;
                    if (field != null) break block5;
                    return null;
                }
                maxX = field.getWidth();
                maxY = field.getHeight();
                if (maxX != 0 && maxY != 0) break block6;
                return null;
            }
            double divideByX = maxX % 2 == 0 ? 3.0 * (double)maxX / 2.0 + 0.5 : 3.0 * (double)maxX / 2.0 + 2.0;
            double divideByY = 1.0 + 2.0 * (double)maxY;
            double xScale = info.draw.width / divideByX;
            double yScale = info.draw.height / divideByY;
            return new Double2D(xScale, yScale);
        }
    }

    @Override
    public Object getPositionLocation(Point2D.Double position, DrawInfo2D info) {
        Double2D scale = this.getScale(info);
        double xScale = scale.x;
        double yScale = scale.y;
        int startx = (int)Math.floor(((position.getX() - info.draw.x) / xScale - 0.5) / 1.5);
        int starty = (int)Math.floor((position.getY() - info.draw.y) / (yScale * 2.0));
        return new Int2D(startx, starty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Point2D.Double getLocationPosition(Object location, DrawInfo2D info) {
        Schedule schedule = info.gui.state.schedule;
        synchronized (schedule) {
            Int2D loc;
            DrawInfo2D newinfo;
            double yScale;
            double xScale;
            Grid2D field;
            block8: {
                int maxY;
                int maxX;
                block7: {
                    block6: {
                        field = (Grid2D)this.field;
                        if (field != null) break block6;
                        return null;
                    }
                    maxX = field.getWidth();
                    maxY = field.getHeight();
                    if (maxX != 0 && maxY != 0) break block7;
                    return null;
                }
                double divideByX = maxX % 2 == 0 ? 3.0 * (double)maxX / 2.0 + 0.5 : 3.0 * (double)maxX / 2.0 + 2.0;
                double divideByY = 1.0 + 2.0 * (double)maxY;
                xScale = info.draw.width / divideByX;
                yScale = info.draw.height / divideByY;
                int startx = (int)Math.floor(((info.clip.x - info.draw.x) / xScale - 0.5) / 1.5) - 2;
                int starty = (int)Math.floor((info.clip.y - info.draw.y) / (yScale * 2.0)) - 2;
                int endx = (int)Math.floor(((info.clip.x - info.draw.x + info.clip.width) / xScale - 0.5) / 1.5) + 4;
                int endy = (int)Math.floor((info.clip.y - info.draw.y + info.clip.height) / (yScale * 2.0)) + 4;
                newinfo = new DrawInfo2D(info.gui, info.fieldPortrayal, new Rectangle2D.Double(0.0, 0.0, Math.ceil(info.draw.width / (HEXAGONAL_RATIO * ((double)(maxX - 1) * 3.0 / 4.0 + 1.0))), Math.ceil(info.draw.height / ((double)maxY + 0.5))), info.clip);
                newinfo.precise = info.precise;
                loc = (Int2D)location;
                if (loc != null) break block8;
                return null;
            }
            int x = loc.x;
            int y = loc.y;
            HexaDenseGridPortrayal2D.getxyC(x, y, xScale, yScale, info.draw.x, info.draw.y, this.xyC);
            HexaDenseGridPortrayal2D.getxyC(field.ulx(x, y), field.uly(x, y), xScale, yScale, info.draw.x, info.draw.y, this.xyC_ul);
            HexaDenseGridPortrayal2D.getxyC(field.upx(x, y), field.upy(x, y), xScale, yScale, info.draw.x, info.draw.y, this.xyC_up);
            HexaDenseGridPortrayal2D.getxyC(field.urx(x, y), field.ury(x, y), xScale, yScale, info.draw.x, info.draw.y, this.xyC_ur);
            this.xPoints[0] = (int)Math.floor(this.xyC_ur[0] - 0.5 * xScale);
            this.yPoints[1] = (int)Math.floor(this.xyC_up[1] + yScale);
            this.xPoints[3] = (int)Math.floor(this.xyC_ul[0] + 0.5 * xScale);
            this.yPoints[4] = (int)Math.floor(this.xyC[1] + yScale);
            newinfo.draw.x = this.xPoints[3];
            newinfo.draw.y = this.yPoints[1];
            newinfo.draw.x += (double)(this.xPoints[0] - this.xPoints[3]) / 2.0;
            newinfo.draw.y += (double)(this.yPoints[4] - this.yPoints[1]) / 2.0;
            return new Point2D.Double(newinfo.draw.x, newinfo.draw.y);
        }
    }

    @Override
    protected void hitOrDraw(Graphics2D graphics, DrawInfo2D info, Bag putInHere) {
        DenseGrid2D field = (DenseGrid2D)this.field;
        Bag policyBag = new Bag();
        if (field == null) {
            return;
        }
        boolean objectSelected = !this.selectedWrappers.isEmpty();
        int maxX = field.getWidth();
        int maxY = field.getHeight();
        if (maxX == 0 || maxY == 0) {
            return;
        }
        double divideByX = maxX % 2 == 0 ? 3.0 * (double)maxX / 2.0 + 0.5 : 3.0 * (double)maxX / 2.0 + 2.0;
        double divideByY = 1.0 + 2.0 * (double)maxY;
        double xScale = info.draw.width / divideByX;
        double yScale = info.draw.height / divideByY;
        int startx = (int)Math.floor(((info.clip.x - info.draw.x) / xScale - 0.5) / 1.5) - 2;
        int starty = (int)Math.floor((info.clip.y - info.draw.y) / (yScale * 2.0)) - 2;
        int endx = (int)Math.floor(((info.clip.x - info.draw.x + info.clip.width) / xScale - 0.5) / 1.5) + 4;
        int endy = (int)Math.floor((info.clip.y - info.draw.y + info.clip.height) / (yScale * 2.0)) + 4;
        DrawInfo2D newinfo = new DrawInfo2D(info.gui, info.fieldPortrayal, new Rectangle2D.Double(0.0, 0.0, Math.ceil(info.draw.width / (HEXAGONAL_RATIO * ((double)(maxX - 1) * 3.0 / 4.0 + 1.0))), Math.ceil(info.draw.height / ((double)maxY + 0.5))), info.clip);
        newinfo.precise = info.precise;
        newinfo.fieldPortrayal = this;
        if (startx < 0) {
            startx = 0;
        }
        if (starty < 0) {
            starty = 0;
        }
        if (endx > maxX) {
            endx = maxX;
        }
        if (endy > maxY) {
            endy = maxY;
        }
        int y = starty;
        while (y < endy) {
            int x = startx;
            while (x < endx) {
                Bag objects = field.field[x][y];
                if (objects != null) {
                    if (this.policy != null & graphics != null) {
                        policyBag.clear();
                        if (this.policy.objectToDraw(objects, policyBag)) {
                            objects = policyBag;
                        }
                    }
                    int i = 0;
                    while (i < objects.numObjs) {
                        Object portrayedObject = objects.objs[i];
                        Portrayal p = this.getPortrayalForObject(portrayedObject);
                        if (!(p instanceof SimplePortrayal2D)) {
                            throw new RuntimeException("Unexpected Portrayal " + p + " for object " + portrayedObject + " -- expected a SimplePortrayal2D");
                        }
                        SimplePortrayal2D portrayal = (SimplePortrayal2D)p;
                        HexaDenseGridPortrayal2D.getxyC(x, y, xScale, yScale, info.draw.x, info.draw.y, this.xyC);
                        HexaDenseGridPortrayal2D.getxyC(field.ulx(x, y), field.uly(x, y), xScale, yScale, info.draw.x, info.draw.y, this.xyC_ul);
                        HexaDenseGridPortrayal2D.getxyC(field.upx(x, y), field.upy(x, y), xScale, yScale, info.draw.x, info.draw.y, this.xyC_up);
                        HexaDenseGridPortrayal2D.getxyC(field.urx(x, y), field.ury(x, y), xScale, yScale, info.draw.x, info.draw.y, this.xyC_ur);
                        this.xPoints[0] = (int)(this.xyC_ur[0] - 0.5 * xScale);
                        this.yPoints[1] = (int)(this.xyC_up[1] + yScale);
                        this.xPoints[3] = (int)(this.xyC_ul[0] + 0.5 * xScale);
                        this.yPoints[4] = (int)(this.xyC[1] + yScale);
                        newinfo.draw.x = this.xPoints[3];
                        newinfo.draw.y = this.yPoints[1];
                        newinfo.draw.x += (double)(this.xPoints[0] - this.xPoints[3]) / 2.0;
                        newinfo.draw.y += (double)(this.yPoints[4] - this.yPoints[1]) / 2.0;
                        this.locationToPass.x = x;
                        this.locationToPass.y = y;
                        if (graphics == null) {
                            if (portrayal.hitObject(portrayedObject, newinfo)) {
                                putInHere.add(this.getWrapper(portrayedObject, new Int2D(x, y)));
                            }
                        } else {
                            portrayal.draw(portrayedObject, graphics, newinfo);
                        }
                        ++i;
                    }
                }
                ++x;
            }
            ++y;
        }
    }
}

