/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.grid;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import sim.display.Display2D;
import sim.field.grid.DoubleGrid2D;
import sim.field.grid.Grid2D;
import sim.field.grid.IntGrid2D;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.grid.HexaValueGridPortrayal2D;
import sim.util.Bag;
import sim.util.Int2D;
import sim.util.MutableDouble;
import sim.util.gui.ColorMap;

public class FastHexaValueGridPortrayal2D
extends HexaValueGridPortrayal2D {
    BufferedImage buffer;
    WritableRaster raster;
    DataBufferInt dbuffer;
    final MutableDouble valueToPass = new MutableDouble(0.0);

    public FastHexaValueGridPortrayal2D(String valueName, boolean immutableField) {
        super(valueName);
        this.setImmutableField(immutableField);
    }

    public FastHexaValueGridPortrayal2D(String valueName) {
        this(valueName, false);
    }

    public FastHexaValueGridPortrayal2D(boolean immutableField) {
        this.setImmutableField(immutableField);
    }

    public FastHexaValueGridPortrayal2D() {
        this(false);
    }

    boolean shouldBuffer(Graphics2D graphics) {
        int buffering = this.getBuffering();
        if (buffering == 1) {
            return true;
        }
        if (buffering == 2) {
            return false;
        }
        if (Display2D.isMacOSX) {
            return graphics.getDeviceConfiguration().getDevice().getType() != 2;
        }
        if (Display2D.isWindows) {
            return this.immutableField;
        }
        return graphics.getDeviceConfiguration().getDevice().getType() != 2;
    }

    @Override
    protected void hitOrDraw(Graphics2D graphics, DrawInfo2D info, Bag putInHere) {
        Grid2D field = (Grid2D)this.field;
        if (field == null) {
            return;
        }
        boolean isDoubleGrid2D = field instanceof DoubleGrid2D;
        int maxX = field.getWidth();
        int maxY = field.getHeight();
        if (maxX == 0 || maxY == 0) {
            return;
        }
        double divideByX = maxX % 2 == 0 ? 3.0 * (double)maxX / 2.0 + 0.5 : 3.0 * (double)maxX / 2.0 + 2.0;
        double scaleWidth = 1.5 * info.draw.width / (maxX % 2 == 0 ? 3.0 * (double)maxX / 2.0 + 0.5 : 3.0 * (double)maxX / 2.0 + 2.0);
        double translateWidth = info.draw.width / divideByX - scaleWidth / 2.0;
        double[][] doubleField = isDoubleGrid2D ? ((DoubleGrid2D)field).field : null;
        int[][] intField = isDoubleGrid2D ? null : ((IntGrid2D)field).field;
        double yScale = info.draw.height / (double)(2 * maxY + 1);
        double startxd = (info.clip.x - translateWidth - info.draw.x) / scaleWidth;
        double startyd = (info.clip.y - info.draw.y) / (2.0 * yScale) - 1.0;
        double endxd = (info.clip.x - translateWidth - info.draw.x + info.clip.width) / scaleWidth;
        double endyd = (info.clip.y - info.draw.y + info.clip.height) / (2.0 * yScale);
        int startx = (int)startxd;
        int starty = (int)startyd;
        int endx = (int)endxd + 1;
        int endy = (int)endyd + 1;
        if (graphics != null && this.shouldBuffer(graphics)) {
            boolean newBuffer = false;
            if (this.buffer == null || this.buffer.getWidth() != maxX || this.buffer.getHeight() != 2 * maxY + 1) {
                if (this.buffer != null) {
                    this.buffer.flush();
                }
                this.buffer = new BufferedImage(maxX, 2 * maxY + 1, 2);
                newBuffer = true;
                this.raster = this.buffer.getRaster();
                this.dbuffer = (DataBufferInt)this.raster.getDataBuffer();
            }
            DataBufferInt _dbuffer = this.dbuffer;
            if (newBuffer || !this.immutableField || this.isDirtyField()) {
                if (endx > maxX) {
                    endx = maxX;
                }
                if (endy > maxY) {
                    endy = maxY;
                }
                if (startx < 0) {
                    startx = 0;
                }
                if (starty < 0) {
                    starty = 0;
                }
                if (this.immutableField) {
                    startx = 0;
                    starty = 0;
                    endx = maxX;
                    endy = maxY;
                }
                int ex = endx;
                int ey = endy;
                int sx = startx;
                int sy = starty;
                ColorMap map = this.map;
                int scanlineStride = ((SinglePixelPackedSampleModel)this.raster.getSampleModel()).getScanlineStride();
                if (isDoubleGrid2D) {
                    int x = sx;
                    while (x < ex) {
                        int y = sy;
                        while (y < ey) {
                            int load;
                            if ((x & 1) == 0) {
                                load = map.getRGB(doubleField[x][y]);
                                _dbuffer.setElem(2 * y * scanlineStride + x, load);
                                _dbuffer.setElem((2 * y + 1) * scanlineStride + x, load);
                            } else {
                                load = map.getRGB(doubleField[x][y]);
                                _dbuffer.setElem((2 * y + 1) * scanlineStride + x, load);
                                _dbuffer.setElem((2 * y + 2) * scanlineStride + x, load);
                            }
                            ++y;
                        }
                        ++x;
                    }
                } else {
                    int x = sx;
                    while (x < ex) {
                        int y = sy;
                        while (y < ey) {
                            int load;
                            if ((x & 1) == 0) {
                                load = map.getRGB(intField[x][y]);
                                _dbuffer.setElem(2 * y * scanlineStride + x, load);
                                _dbuffer.setElem((2 * y + 1) * scanlineStride + x, load);
                            } else {
                                load = map.getRGB(intField[x][y]);
                                _dbuffer.setElem((2 * y + 1) * scanlineStride + x, load);
                                _dbuffer.setElem((2 * y + 2) * scanlineStride + x, load);
                            }
                            ++y;
                        }
                        ++x;
                    }
                }
            }
            graphics.drawImage(this.buffer, (int)(info.draw.x + translateWidth), (int)info.draw.y, (int)((double)maxX * scaleWidth), (int)info.draw.height, null);
        } else if (!info.precise) {
            this.buffer = null;
            if (endx > maxX) {
                endx = maxX;
            }
            if (endy > maxY) {
                endy = maxY;
            }
            if (startx < 0) {
                startx = 0;
            }
            if (starty < 0) {
                starty = 0;
            }
            int ex = endx;
            int ey = endy;
            int sx = startx;
            int sy = starty;
            int _x = 0;
            int _y = 0;
            int _width = 0;
            int _height = 0;
            ColorMap map = this.map;
            double infodrawx = info.draw.x;
            double infodrawy = info.draw.y;
            if (isDoubleGrid2D) {
                int x = sx;
                while (x < ex) {
                    int y = sy;
                    while (y < ey) {
                        Color c = map.getColor(doubleField[x][y]);
                        if (c.getAlpha() != 0) {
                            _x = (int)(translateWidth + infodrawx + scaleWidth * (double)x);
                            _y = (int)(infodrawy + yScale * (double)((x & 1) == 0 ? 2 * y : 2 * y + 1));
                            _width = (int)(translateWidth + infodrawx + scaleWidth * (double)(x + 1)) - _x;
                            _height = (int)(infodrawy + yScale * (double)((x & 1) == 0 ? 2 * y + 2 : 2 * y + 3)) - _y;
                            if (graphics != null) {
                                graphics.setColor(c);
                                graphics.fillRect(_x, _y, _width, _height);
                            } else if (info.clip.intersects(_x, _y, _width, _height)) {
                                putInHere.add(this.getWrapper(doubleField[x][y], new Int2D(x, y)));
                            }
                        }
                        ++y;
                    }
                    ++x;
                }
            } else {
                int x = sx;
                while (x < ex) {
                    int y = sy;
                    while (y < ey) {
                        Color c = map.getColor(intField[x][y]);
                        if (c.getAlpha() != 0) {
                            _x = (int)(translateWidth + infodrawx + scaleWidth * (double)x);
                            _y = (int)(infodrawy + yScale * (double)((x & 1) == 0 ? 2 * y : 2 * y + 1));
                            _width = (int)(translateWidth + infodrawx + scaleWidth * (double)(x + 1)) - _x;
                            _height = (int)(infodrawy + yScale * (double)((x & 1) == 0 ? 2 * y + 2 : 2 * y + 3)) - _y;
                            if (graphics != null) {
                                graphics.setColor(c);
                                graphics.fillRect(_x, _y, _width, _height);
                            } else if (info.clip.intersects(_x, _y, _width, _height)) {
                                putInHere.add(this.getWrapper(intField[x][y], new Int2D(x, y)));
                            }
                        }
                        ++y;
                    }
                    ++x;
                }
            }
        } else {
            graphics.setStroke(new BasicStroke(0.0f));
            Rectangle2D.Double preciseRectangle = new Rectangle2D.Double();
            this.buffer = null;
            if (endxd > (double)maxX) {
                endxd = maxX;
            }
            if (endyd > (double)maxY) {
                endyd = maxY;
            }
            if (startxd < 0.0) {
                startxd = 0.0;
            }
            if (startyd < 0.0) {
                startyd = 0.0;
            }
            double _x = 0.0;
            double _y = 0.0;
            double _width = 0.0;
            double _height = 0.0;
            ColorMap map = this.map;
            double infodrawx = info.draw.x;
            double infodrawy = info.draw.y;
            if (isDoubleGrid2D) {
                double x = startxd;
                while (x < endxd) {
                    double y = startyd;
                    while (y < endyd) {
                        Color c = map.getColor(doubleField[(int)x][(int)y]);
                        if (c.getAlpha() != 0) {
                            graphics.setColor(c);
                            _x = translateWidth + infodrawx + scaleWidth * x;
                            _y = infodrawy + yScale * (((int)x & 1) == 0 ? 2.0 * y : 2.0 * y + 1.0);
                            _width = translateWidth + infodrawx + scaleWidth * (x + 1.0) - _x;
                            _height = infodrawy + yScale * (((int)x & 1) == 0 ? 2.0 * y + 2.0 : 2.0 * y + 3.0) - _y;
                            preciseRectangle.setFrame(_x, _y, _width, _height);
                            graphics.fill(preciseRectangle);
                            graphics.draw(preciseRectangle);
                        }
                        y += 1.0;
                    }
                    x += 1.0;
                }
            } else {
                double x = startxd;
                while (x < endxd) {
                    double y = startyd;
                    while (y < endyd) {
                        Color c = map.getColor(intField[(int)x][(int)y]);
                        if (c.getAlpha() != 0) {
                            graphics.setColor(c);
                            _x = translateWidth + infodrawx + scaleWidth * x;
                            _y = infodrawy + yScale * (((int)x & 1) == 0 ? 2.0 * y : 2.0 * y + 1.0);
                            _width = translateWidth + infodrawx + scaleWidth * (x + 1.0) - _x;
                            _height = infodrawy + yScale * (((int)x & 1) == 0 ? 2.0 * y + 2.0 : 2.0 * y + 3.0) - _y;
                            preciseRectangle.setFrame(_x, _y, _width, _height);
                            graphics.fill(preciseRectangle);
                            graphics.draw(preciseRectangle);
                        }
                        y += 1.0;
                    }
                    x += 1.0;
                }
            }
        }
        if (graphics != null) {
            this.setDirtyField(false);
        }
    }
}

