/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.grid;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import sim.display.GUIState;
import sim.engine.Schedule;
import sim.field.grid.DenseGrid2D;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.Portrayal;
import sim.portrayal.SimplePortrayal2D;
import sim.portrayal.grid.DrawPolicy;
import sim.portrayal.grid.ObjectGridPortrayal2D;
import sim.util.Bag;
import sim.util.Int2D;
import sim.util.MutableInt2D;

public class DenseGridPortrayal2D
extends ObjectGridPortrayal2D {
    public DrawPolicy policy;
    protected final MutableInt2D locationToPass = new MutableInt2D(0, 0);

    public DenseGridPortrayal2D() {
    }

    public DenseGridPortrayal2D(DrawPolicy policy) {
        this.policy = policy;
    }

    public void setDrawPolicy(DrawPolicy policy) {
        this.policy = policy;
    }

    public DrawPolicy getDrawPolicy() {
        return this.policy;
    }

    @Override
    public void setField(Object field) {
        if (!(field instanceof DenseGrid2D)) {
            throw new RuntimeException("Invalid field for DenseGridPortrayal2D: " + field);
        }
        super.setField(field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObjectLocation(Object object, GUIState gui) {
        Schedule schedule = gui.state.schedule;
        synchronized (schedule) {
            int maxY;
            int maxX;
            DenseGrid2D field;
            block11: {
                block10: {
                    field = (DenseGrid2D)this.field;
                    if (field != null) break block10;
                    return null;
                }
                maxX = field.getWidth();
                maxY = field.getHeight();
                if (maxX != 0 && maxY != 0) break block11;
                return null;
            }
            int x = 0;
            while (x < maxX) {
                Bag[] fieldx = field.field[x];
                int y = 0;
                while (y < maxY) {
                    Bag objects = fieldx[y];
                    if (objects != null) {
                        int i = 0;
                        while (i < objects.numObjs) {
                            if (objects.objs[i] == object) {
                                return new Int2D(x, y);
                            }
                            ++i;
                        }
                    }
                    ++y;
                }
                ++x;
            }
            return null;
        }
    }

    @Override
    protected void hitOrDraw(Graphics2D graphics, DrawInfo2D info, Bag putInHere) {
        DenseGrid2D field = (DenseGrid2D)this.field;
        Bag policyBag = new Bag();
        if (field == null) {
            return;
        }
        boolean objectSelected = !this.selectedWrappers.isEmpty();
        Object selectedObject = this.selectedWrapper == null ? null : this.selectedWrapper.getObject();
        int maxX = field.getWidth();
        int maxY = field.getHeight();
        if (maxX == 0 || maxY == 0) {
            return;
        }
        double xScale = info.draw.width / (double)maxX;
        double yScale = info.draw.height / (double)maxY;
        int startx = (int)((info.clip.x - info.draw.x) / xScale);
        int starty = (int)((info.clip.y - info.draw.y) / yScale);
        int endx = (int)((info.clip.x - info.draw.x + info.clip.width) / xScale) + 1;
        int endy = (int)((info.clip.y - info.draw.y + info.clip.height) / yScale) + 1;
        DrawInfo2D newinfo = new DrawInfo2D(info.gui, info.fieldPortrayal, new Rectangle2D.Double(0.0, 0.0, xScale, yScale), info.clip);
        newinfo.precise = info.precise;
        newinfo.location = this.locationToPass;
        if (endx > maxX) {
            endx = maxX;
        }
        if (endy > maxY) {
            endy = maxY;
        }
        if (startx < 0) {
            startx = 0;
        }
        if (starty < 0) {
            starty = 0;
        }
        int x = startx;
        while (x < endx) {
            int y = starty;
            while (y < endy) {
                Bag objects = field.field[x][y];
                if (objects != null) {
                    if (this.policy != null & graphics != null) {
                        policyBag.clear();
                        if (this.policy.objectToDraw(objects, policyBag)) {
                            objects = policyBag;
                        }
                    }
                    this.locationToPass.x = x;
                    this.locationToPass.y = y;
                    int i = 0;
                    while (i < objects.numObjs) {
                        Object portrayedObject = objects.objs[i];
                        Portrayal p = this.getPortrayalForObject(portrayedObject);
                        if (!(p instanceof SimplePortrayal2D)) {
                            throw new RuntimeException("Unexpected Portrayal " + p + " for object " + portrayedObject + " -- expected a SimplePortrayal2D");
                        }
                        SimplePortrayal2D portrayal = (SimplePortrayal2D)p;
                        newinfo.draw.x = (int)(info.draw.x + xScale * (double)x);
                        newinfo.draw.y = (int)(info.draw.y + yScale * (double)y);
                        newinfo.draw.width = (double)((int)(info.draw.x + xScale * (double)(x + 1))) - newinfo.draw.x;
                        newinfo.draw.height = (double)((int)(info.draw.y + yScale * (double)(y + 1))) - newinfo.draw.y;
                        newinfo.draw.x += newinfo.draw.width / 2.0;
                        newinfo.draw.y += newinfo.draw.height / 2.0;
                        if (graphics == null) {
                            if (portrayedObject != null && portrayal.hitObject(portrayedObject, newinfo)) {
                                putInHere.add(this.getWrapper(portrayedObject, new Int2D(x, y)));
                            }
                        } else {
                            newinfo.selected = objectSelected && (selectedObject == portrayedObject || this.selectedWrappers.get(portrayedObject) != null);
                            portrayal.draw(portrayedObject, graphics, newinfo);
                        }
                        ++i;
                    }
                }
                ++y;
            }
            ++x;
        }
    }

    @Override
    Int2D searchForObject(Object object, Int2D loc) {
        Bag b;
        DenseGrid2D field = (DenseGrid2D)this.field;
        Bag[][] grid = field.field;
        if (grid[loc.x][loc.y] != null && (b = grid[loc.x][loc.y]).contains(object)) {
            return new Int2D(loc.x, loc.y);
        }
        field.getMooreLocations(loc.x, loc.y, 3, 2, false, this.xPos, this.yPos);
        int i = 0;
        while (i < this.xPos.numObjs) {
            Bag b2;
            if (grid[this.xPos.get(i)][this.yPos.get(i)] != null && (b2 = grid[this.xPos.get(i)][this.yPos.get(i)]).contains(object)) {
                return new Int2D(this.xPos.get(i), this.yPos.get(i));
            }
            ++i;
        }
        return null;
    }
}

