/*
 * Decompiled with CFR 0.152.
 */
package sim.field.grid;

import sim.field.grid.AbstractGrid3D;
import sim.field.grid.IntGrid3D;
import sim.util.DoubleBag;
import sim.util.Int3D;
import sim.util.IntBag;
import sim.util.LocationLog;

public class DoubleGrid3D
extends AbstractGrid3D {
    private static final long serialVersionUID = 1L;
    public double[][][] field;

    public DoubleGrid3D(int width, int height, int length) {
        this.width = width;
        this.height = height;
        this.length = length;
        this.field = new double[width][height][length];
    }

    public DoubleGrid3D(int width, int height, int length, double initialValue) {
        this(width, height, length);
        this.setTo(initialValue);
    }

    public DoubleGrid3D(DoubleGrid3D values) {
        this.setTo(values);
    }

    public final double set(int x, int y, int z, double val) {
        double returnval = this.field[x][y][z];
        this.field[x][y][z] = val;
        return returnval;
    }

    public final double get(int x, int y, int z) {
        return this.field[x][y][z];
    }

    public final double[] toArray() {
        double[][][] field = this.field;
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        double[] vals = new double[width * height * length];
        int i = 0;
        int x = 0;
        while (x < width) {
            fieldx = field[x];
            int y = 0;
            while (y < height) {
                fieldxy = fieldx[y];
                int z = 0;
                while (z < length) {
                    vals[i++] = fieldxy[z];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return vals;
    }

    public final double max() {
        double max = Double.NEGATIVE_INFINITY;
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        int x = 0;
        while (x < width) {
            fieldx = this.field[x];
            int y = 0;
            while (y < height) {
                fieldxy = fieldx[y];
                int z = 0;
                while (z < length) {
                    if (max < fieldxy[z]) {
                        max = fieldxy[z];
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return max;
    }

    public final double min() {
        double min = Double.POSITIVE_INFINITY;
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        int x = 0;
        while (x < width) {
            fieldx = this.field[x];
            int y = 0;
            while (y < height) {
                fieldxy = fieldx[y];
                int z = 0;
                while (z < length) {
                    if (min > fieldxy[z]) {
                        min = fieldxy[z];
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return min;
    }

    public final double mean() {
        long count = 0L;
        double mean = 0.0;
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        int x = 0;
        while (x < width) {
            fieldx = this.field[x];
            int y = 0;
            while (y < height) {
                fieldxy = fieldx[y];
                int z = 0;
                while (z < length) {
                    mean += fieldxy[z];
                    ++count;
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return count == 0L ? 0.0 : mean / (double)count;
    }

    public final DoubleGrid3D setTo(double thisMuch) {
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        int x = 0;
        while (x < width) {
            fieldx = this.field[x];
            int y = 0;
            while (y < height) {
                fieldxy = fieldx[y];
                int z = 0;
                while (z < length) {
                    fieldxy[z] = thisMuch;
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return this;
    }

    public final DoubleGrid3D setTo(DoubleGrid3D values) {
        if (this.width != values.width || this.height != values.height || this.length != values.length) {
            int width = this.width = values.width;
            int height = this.height = values.height;
            this.length = values.length;
            this.field = new double[width][height][];
            double[][] fieldx = null;
            int x = 0;
            while (x < width) {
                fieldx = this.field[x];
                int y = 0;
                while (y < height) {
                    fieldx[y] = (double[])values.field[x][y].clone();
                    ++y;
                }
                ++x;
            }
        } else {
            int x = 0;
            while (x < this.width) {
                int y = 0;
                while (y < this.height) {
                    System.arraycopy(values.field[x][y], 0, this.field[x][y], 0, this.length);
                    ++y;
                }
                ++x;
            }
        }
        return this;
    }

    public final DoubleGrid3D upperBound(double toNoMoreThanThisMuch) {
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        int x = 0;
        while (x < width) {
            fieldx = this.field[x];
            int y = 0;
            while (y < height) {
                fieldxy = fieldx[y];
                int z = 0;
                while (z < length) {
                    if (fieldxy[z] > toNoMoreThanThisMuch) {
                        fieldxy[z] = toNoMoreThanThisMuch;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return this;
    }

    public final DoubleGrid3D lowerBound(double toNoLowerThanThisMuch) {
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        int x = 0;
        while (x < width) {
            fieldx = this.field[x];
            int y = 0;
            while (y < height) {
                fieldxy = fieldx[y];
                int z = 0;
                while (z < length) {
                    if (fieldxy[z] < toNoLowerThanThisMuch) {
                        fieldxy[z] = toNoLowerThanThisMuch;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return this;
    }

    public final DoubleGrid3D add(double withThisMuch) {
        if (withThisMuch == 0.0) {
            return this;
        }
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        int x = 0;
        while (x < width) {
            fieldx = this.field[x];
            int y = 0;
            while (y < height) {
                fieldxy = fieldx[y];
                int z = 0;
                while (z < length) {
                    int n = z++;
                    fieldxy[n] = fieldxy[n] + withThisMuch;
                }
                ++y;
            }
            ++x;
        }
        return this;
    }

    public final DoubleGrid3D add(IntGrid3D withThis) {
        int[][][] otherField = withThis.field;
        int[][] ofieldx = null;
        int[] ofieldxy = null;
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        int x = 0;
        while (x < width) {
            fieldx = this.field[x];
            ofieldx = otherField[x];
            int y = 0;
            while (y < height) {
                ofieldxy = ofieldx[y];
                fieldxy = fieldx[y];
                int z = 0;
                while (z < length) {
                    int n = z;
                    fieldxy[n] = fieldxy[n] + (double)ofieldxy[z];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return this;
    }

    public final DoubleGrid3D add(DoubleGrid3D withThis) {
        double[][][] otherField = withThis.field;
        double[][] ofieldx = null;
        double[] ofieldxy = null;
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        int x = 0;
        while (x < width) {
            fieldx = this.field[x];
            ofieldx = otherField[x];
            int y = 0;
            while (y < height) {
                fieldxy = fieldx[y];
                ofieldxy = ofieldx[y];
                int z = 0;
                while (z < length) {
                    int n = z;
                    fieldxy[n] = fieldxy[n] + ofieldxy[z];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return this;
    }

    public final DoubleGrid3D multiply(double byThisMuch) {
        if (byThisMuch == 1.0) {
            return this;
        }
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        int x = 0;
        while (x < width) {
            fieldx = this.field[x];
            int y = 0;
            while (y < height) {
                fieldxy = fieldx[y];
                int z = 0;
                while (z < length) {
                    int n = z++;
                    fieldxy[n] = fieldxy[n] * byThisMuch;
                }
                ++y;
            }
            ++x;
        }
        return this;
    }

    public final DoubleGrid3D multiply(IntGrid3D withThis) {
        int[][][] otherField = withThis.field;
        int[][] ofieldx = null;
        int[] ofieldxy = null;
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        int x = 0;
        while (x < width) {
            fieldx = this.field[x];
            ofieldx = otherField[x];
            int y = 0;
            while (y < height) {
                ofieldxy = ofieldx[y];
                fieldxy = fieldx[y];
                int z = 0;
                while (z < length) {
                    int n = z;
                    fieldxy[n] = fieldxy[n] * (double)ofieldxy[z];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return this;
    }

    public final DoubleGrid3D multiply(DoubleGrid3D withThis) {
        double[][][] otherField = withThis.field;
        double[][] ofieldx = null;
        double[] ofieldxy = null;
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        int x = 0;
        while (x < width) {
            fieldx = this.field[x];
            ofieldx = otherField[x];
            int y = 0;
            while (y < height) {
                fieldxy = fieldx[y];
                ofieldxy = ofieldx[y];
                int z = 0;
                while (z < length) {
                    int n = z;
                    fieldxy[n] = fieldxy[n] * ofieldxy[z];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return this;
    }

    public final DoubleGrid3D floor() {
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        int x = 0;
        while (x < width) {
            fieldx = this.field[x];
            int y = 0;
            while (y < height) {
                fieldxy = fieldx[y];
                int z = 0;
                while (z < length) {
                    fieldxy[z] = Math.floor(fieldxy[z]);
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return this;
    }

    public final DoubleGrid3D ceiling() {
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        int x = 0;
        while (x < width) {
            fieldx = this.field[x];
            int y = 0;
            while (y < height) {
                fieldxy = fieldx[y];
                int z = 0;
                while (z < length) {
                    fieldxy[z] = Math.ceil(fieldxy[z]);
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return this;
    }

    public final DoubleGrid3D truncate() {
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        int x = 0;
        while (x < width) {
            fieldx = this.field[x];
            int y = 0;
            while (y < height) {
                fieldxy = fieldx[y];
                int z = 0;
                while (z < length) {
                    if (fieldxy[z] > 0.0) {
                        Math.floor(fieldxy[z]);
                    } else {
                        Math.ceil(fieldxy[z]);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return this;
    }

    public final DoubleGrid3D rint() {
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        int x = 0;
        while (x < width) {
            fieldx = this.field[x];
            int y = 0;
            while (y < height) {
                fieldxy = fieldx[y];
                int z = 0;
                while (z < length) {
                    fieldxy[z] = Math.rint(fieldxy[z]);
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return this;
    }

    public void getNeighborsMaxDistance(int x, int y, int z, int dist, boolean toroidal, DoubleBag result, IntBag xPos, IntBag yPos, IntBag zPos) {
        this.getMooreNeighbors(x, y, z, dist, toroidal ? 2 : 0, true, result, xPos, yPos, zPos);
    }

    public DoubleBag getMooreNeighbors(int x, int y, int z, int dist, int mode, boolean includeOrigin, DoubleBag result, IntBag xPos, IntBag yPos, IntBag zPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        if (zPos == null) {
            zPos = new IntBag();
        }
        this.getMooreLocations(x, y, z, dist, mode, includeOrigin, xPos, yPos, zPos);
        return this.getObjectsAtLocations(xPos, yPos, zPos, result);
    }

    public void getNeighborsHamiltonianDistance(int x, int y, int z, int dist, boolean toroidal, DoubleBag result, IntBag xPos, IntBag yPos, IntBag zPos) {
        this.getVonNeumannNeighbors(x, y, z, dist, toroidal ? 2 : 0, true, result, xPos, yPos, zPos);
    }

    public DoubleBag getVonNeumannNeighbors(int x, int y, int z, int dist, int mode, boolean includeOrigin, DoubleBag result, IntBag xPos, IntBag yPos, IntBag zPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        if (zPos == null) {
            zPos = new IntBag();
        }
        this.getVonNeumannLocations(x, y, z, dist, mode, includeOrigin, xPos, yPos, zPos);
        return this.getObjectsAtLocations(xPos, yPos, zPos, result);
    }

    public DoubleBag getRadialNeighbors(int x, int y, int z, int dist, int mode, boolean includeOrigin, DoubleBag result, IntBag xPos, IntBag yPos, IntBag zPos) {
        return this.getRadialNeighbors(x, y, z, dist, mode, includeOrigin, result, xPos, yPos, zPos);
    }

    public DoubleBag getRadialNeighbors(int x, int y, int z, int dist, int mode, boolean includeOrigin, int measurementRule, boolean closed, DoubleBag result, IntBag xPos, IntBag yPos, IntBag zPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        if (zPos == null) {
            zPos = new IntBag();
        }
        this.getRadialLocations(x, y, z, dist, mode, includeOrigin, measurementRule, closed, xPos, yPos, zPos);
        return this.getObjectsAtLocations(xPos, yPos, zPos, result);
    }

    void reduceObjectsAtLocations(IntBag xPos, IntBag yPos, IntBag zPos, DoubleBag result) {
        if (result == null) {
            result = new DoubleBag();
        } else {
            result.clear();
        }
        int i = 0;
        while (i < xPos.numObjs) {
            assert (LocationLog.it(this, new Int3D(xPos.objs[i], yPos.objs[i], zPos.objs[i])));
            double val = this.field[xPos.objs[i]][yPos.objs[i]][zPos.objs[i]];
            result.add(val);
            ++i;
        }
    }

    DoubleBag getObjectsAtLocations(IntBag xPos, IntBag yPos, IntBag zPos, DoubleBag result) {
        if (result == null) {
            result = new DoubleBag();
        } else {
            result.clear();
        }
        int i = 0;
        while (i < xPos.numObjs) {
            assert (LocationLog.it(this, new Int3D(xPos.objs[i], yPos.objs[i], zPos.objs[i])));
            double val = this.field[xPos.objs[i]][yPos.objs[i]][zPos.objs[i]];
            result.add(val);
            ++i;
        }
        return result;
    }
}

