/*
 * Decompiled with CFR 0.152.
 */
package sim.field.grid;

import java.util.Collection;
import sim.field.grid.AbstractGrid3D;
import sim.util.Bag;
import sim.util.Int3D;
import sim.util.IntBag;

public class DenseGrid3D
extends AbstractGrid3D {
    private static final long serialVersionUID = 1L;
    public boolean removeEmptyBags = true;
    public boolean replaceLargeBags = true;
    public static final int INITIAL_BAG_SIZE = 16;
    public static final int MIN_BAG_SIZE = 32;
    public static final int LARGE_BAG_RATIO = 4;
    public static final int REPLACEMENT_BAG_RATIO = 2;
    public Bag[][][] field;

    public DenseGrid3D(int width, int height, int length) {
        this.width = width;
        this.height = height;
        this.length = length;
        this.field = new Bag[width][height][length];
    }

    public Bag getObjectsAtLocation(int x, int y, int z) {
        return this.field[x][y][z];
    }

    public Bag getObjectsAtLocation(Int3D location) {
        return this.getObjectsAtLocation(location.x, location.y, location.z);
    }

    public Bag removeObjectsAtLocation(int x, int y, int z) {
        Bag b = this.field[x][y][z];
        this.field[x][y][z] = null;
        return b;
    }

    public Bag removeObjectsAtLocation(Int3D location) {
        return this.removeObjectsAtLocation(location.x, location.y, location.z);
    }

    public boolean removeObjectAtLocation(Object obj, int x, int y, int z) {
        Bag b = this.field[x][y][z];
        if (b == null) {
            return false;
        }
        boolean result = b.remove(obj);
        int objsNumObjs = b.numObjs;
        if (this.removeEmptyBags && objsNumObjs == 0) {
            b = null;
        } else if (this.replaceLargeBags && objsNumObjs >= 32 && objsNumObjs * 4 <= b.objs.length) {
            b.shrink(objsNumObjs * 2);
        }
        return result;
    }

    public boolean removeObjectAtLocation(Object obj, Int3D location) {
        return this.removeObjectAtLocation(obj, location.x, location.y, location.z);
    }

    public boolean removeObjectMultiplyAtLocation(Object obj, int x, int y, int z) {
        Bag b = this.field[x][y][z];
        if (b == null) {
            return false;
        }
        boolean result = b.removeMultiply(obj);
        int objsNumObjs = b.numObjs;
        if (this.removeEmptyBags && objsNumObjs == 0) {
            b = null;
        } else if (this.replaceLargeBags && objsNumObjs >= 32 && objsNumObjs * 4 <= b.objs.length) {
            b.shrink(objsNumObjs * 2);
        }
        return result;
    }

    public boolean removeObjectMultiplyAtLocation(Object obj, Int3D location) {
        return this.removeObjectMultiplyAtLocation(obj, location.x, location.y, location.z);
    }

    public boolean moveObject(Object obj, int fromX, int fromY, int fromZ, int toX, int toY, int toZ) {
        boolean result = this.removeObjectAtLocation(obj, fromX, fromY, fromZ);
        this.addObjectToLocation(obj, toX, toY, toZ);
        return result;
    }

    public boolean moveObject(Object obj, Int3D from, Int3D to) {
        return this.moveObject(obj, from.x, from.y, from.z, to.x, to.y, to.z);
    }

    public void moveObjects(int fromX, int fromY, int fromZ, int toX, int toY, int toZ) {
        this.addObjectsToLocation(this.removeObjectsAtLocation(fromX, fromY, fromZ), toX, toY, toZ);
    }

    public void moveObjects(Int3D from, Int3D to) {
        this.moveObjects(from.x, from.y, from.z, to.x, to.y, to.z);
    }

    public int numObjectsAtLocation(int x, int y, int z) {
        Bag b = this.field[x][y][z];
        if (b == null) {
            return 0;
        }
        return b.numObjs;
    }

    public int numObjectsAtLocation(Int3D location) {
        return this.numObjectsAtLocation(location.x, location.y, location.z);
    }

    void buildBag(Bag[] fieldxy, int z) {
        fieldxy[z] = new Bag(16);
    }

    public void addObjectToLocation(Object obj, int x, int y, int z) {
        Bag[] fieldxy = this.field[x][y];
        if (fieldxy[z] == null) {
            this.buildBag(fieldxy, z);
        }
        fieldxy[z].add(obj);
    }

    public void addObjectToLocation(Object obj, Int3D location) {
        this.addObjectToLocation(obj, location.x, location.y, location.z);
    }

    public void addObjectsToLocation(Bag objs, int x, int y, int z) {
        if (objs == null) {
            return;
        }
        Bag[] fieldxy = this.field[x][y];
        if (fieldxy[z] == null) {
            this.buildBag(fieldxy, z);
        }
        fieldxy[z].addAll(objs);
    }

    public void addObjectsToLocation(Bag objs, Int3D location) {
        this.addObjectsToLocation(objs, location.x, location.y, location.z);
    }

    public void addObjectsToLocation(Object[] objs, int x, int y, int z) {
        if (objs == null) {
            return;
        }
        Bag[] fieldxy = this.field[x][y];
        if (fieldxy[z] == null) {
            this.buildBag(fieldxy, z);
        }
        fieldxy[z].addAll(0, objs);
    }

    public void addObjectsToLocation(Object[] objs, Int3D location) {
        this.addObjectsToLocation(objs, location.x, location.y, location.z);
    }

    public void addObjectsToLocation(Collection objs, int x, int y, int z) {
        if (objs == null) {
            return;
        }
        Bag[] fieldxy = this.field[x][y];
        if (fieldxy[z] == null) {
            this.buildBag(fieldxy, z);
        }
        fieldxy[z].addAll(objs);
    }

    public final Bag clear() {
        Bag bag = new Bag();
        Bag[][] fieldx = null;
        Bag[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int x = 0;
        while (x < width) {
            fieldx = this.field[x];
            int y = 0;
            while (y < height) {
                fieldxy = fieldx[y];
                int z = 0;
                while (z < this.length) {
                    if (fieldxy[z] != null) {
                        bag.addAll(fieldxy[z]);
                    }
                    fieldxy[z] = null;
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return bag;
    }

    public Bag getNeighborsMaxDistance(int x, int y, int z, int dist, boolean toroidal, Bag result, IntBag xPos, IntBag yPos, IntBag zPos) {
        return this.getMooreNeighbors(x, y, z, dist, toroidal ? 2 : 0, true, result, xPos, yPos, zPos);
    }

    public Bag getMooreNeighbors(int x, int y, int z, int dist, int mode, boolean includeOrigin, Bag result, IntBag xPos, IntBag yPos, IntBag zPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        if (zPos == null) {
            zPos = new IntBag();
        }
        this.getMooreLocations(x, y, z, dist, mode, includeOrigin, xPos, yPos, zPos);
        return this.getObjectsAtLocations(xPos, yPos, zPos, result);
    }

    public Bag getMooreNeighborsAndLocations(int x, int y, int z, int dist, int mode, boolean includeOrigin, Bag result, IntBag xPos, IntBag yPos, IntBag zPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        if (zPos == null) {
            zPos = new IntBag();
        }
        this.getMooreLocations(x, y, z, dist, mode, includeOrigin, xPos, yPos, zPos);
        this.reduceObjectsAtLocations(xPos, yPos, zPos, result);
        return result;
    }

    public void getNeighborsHamiltonianDistance(int x, int y, int z, int dist, boolean toroidal, Bag result, IntBag xPos, IntBag yPos, IntBag zPos) {
        this.getVonNeumannNeighbors(x, y, z, dist, toroidal ? 2 : 0, true, result, xPos, yPos, zPos);
    }

    public Bag getVonNeumannNeighbors(int x, int y, int z, int dist, int mode, boolean includeOrigin, Bag result, IntBag xPos, IntBag yPos, IntBag zPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        if (zPos == null) {
            zPos = new IntBag();
        }
        this.getVonNeumannLocations(x, y, z, dist, mode, includeOrigin, xPos, yPos, zPos);
        return this.getObjectsAtLocations(xPos, yPos, zPos, result);
    }

    public Bag getVonNeumannNeighborsAndLocations(int x, int y, int z, int dist, int mode, boolean includeOrigin, Bag result, IntBag xPos, IntBag yPos, IntBag zPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        if (zPos == null) {
            zPos = new IntBag();
        }
        this.getVonNeumannLocations(x, y, z, dist, mode, includeOrigin, xPos, yPos, zPos);
        this.reduceObjectsAtLocations(xPos, yPos, zPos, result);
        return result;
    }

    public Bag getRadialNeighbors(int x, int y, int z, int dist, int mode, boolean includeOrigin, Bag result, IntBag xPos, IntBag yPos, IntBag zPos) {
        return this.getRadialNeighbors(x, y, z, dist, mode, includeOrigin, 1026, true, result, xPos, yPos, zPos);
    }

    public Bag getRadialNeighborsAndLocations(int x, int y, int z, int dist, int mode, boolean includeOrigin, Bag result, IntBag xPos, IntBag yPos, IntBag zPos) {
        return this.getRadialNeighborsAndLocations(x, y, z, dist, mode, includeOrigin, 1026, true, result, xPos, yPos, zPos);
    }

    public Bag getRadialNeighbors(int x, int y, int z, int dist, int mode, boolean includeOrigin, int measurementRule, boolean closed, Bag result, IntBag xPos, IntBag yPos, IntBag zPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        if (zPos == null) {
            zPos = new IntBag();
        }
        this.getRadialLocations(x, y, z, dist, mode, includeOrigin, measurementRule, closed, xPos, yPos, zPos);
        return this.getObjectsAtLocations(xPos, yPos, zPos, result);
    }

    public Bag getRadialNeighborsAndLocations(int x, int y, int z, int dist, int mode, boolean includeOrigin, int measurementRule, boolean closed, Bag result, IntBag xPos, IntBag yPos, IntBag zPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        if (zPos == null) {
            zPos = new IntBag();
        }
        this.getRadialLocations(x, y, z, dist, mode, includeOrigin, measurementRule, closed, xPos, yPos, zPos);
        this.reduceObjectsAtLocations(xPos, yPos, zPos, result);
        return result;
    }

    void reduceObjectsAtLocations(IntBag xPos, IntBag yPos, IntBag zPos, Bag result) {
        if (result == null) {
            result = new Bag();
        } else {
            result.clear();
        }
        IntBag newXPos = new IntBag();
        IntBag newYPos = new IntBag();
        IntBag newZPos = new IntBag();
        int len = xPos.numObjs;
        int[] xs = xPos.objs;
        int[] ys = yPos.objs;
        int[] zs = zPos.objs;
        int i = 0;
        while (i < len) {
            Bag temp = this.field[xPos.objs[i]][yPos.objs[i]][zPos.objs[i]];
            int size = temp.numObjs;
            Object[] os = temp.objs;
            int j = 0;
            while (j < size) {
                result.add(os[j]);
                newXPos.add(xs[i]);
                newYPos.add(ys[i]);
                newZPos.add(zs[i]);
                ++j;
            }
            ++i;
        }
        xPos.clear();
        xPos.addAll(newXPos);
        yPos.clear();
        yPos.addAll(newYPos);
        zPos.clear();
        zPos.addAll(newZPos);
    }

    Bag getObjectsAtLocations(IntBag xPos, IntBag yPos, IntBag zPos, Bag result) {
        if (result == null) {
            result = new Bag();
        } else {
            result.clear();
        }
        int len = xPos.numObjs;
        int[] xs = xPos.objs;
        int[] ys = yPos.objs;
        int[] zs = zPos.objs;
        int i = 0;
        while (i < len) {
            Bag temp = this.field[xPos.objs[i]][yPos.objs[i]][zPos.objs[i]];
            if (temp != null) {
                int n = temp.numObjs;
                if (n == 1) {
                    result.add(temp.objs[0]);
                } else if (n > 1) {
                    result.addAll(temp);
                }
            }
            ++i;
        }
        return result;
    }
}

