/*
 * Decompiled with CFR 0.152.
 */
package sim.field.continuous;

import java.util.Map;
import sim.field.SparseField;
import sim.field.SparseField3D;
import sim.util.Bag;
import sim.util.Double3D;
import sim.util.Int3D;
import sim.util.MutableInt3D;

public class Continuous3D
extends SparseField
implements SparseField3D {
    private static final long serialVersionUID = 1L;
    public Map doubleLocationHash = this.buildMap(0);
    public double width;
    public double height;
    public double length;
    public final double discretization;
    MutableInt3D speedyMutableInt3D = new MutableInt3D();

    public Continuous3D(double discretization, double width, double height, double length) {
        this.discretization = discretization;
        this.width = width;
        this.height = height;
        this.length = length;
    }

    public Continuous3D(Continuous3D other) {
        super(other);
        this.discretization = other.discretization;
        this.width = other.width;
        this.height = other.height;
        this.length = other.length;
    }

    public final Double3D getObjectLocation(Object obj) {
        return (Double3D)this.doubleLocationHash.get(obj);
    }

    public final Int3D discretize(Double3D location) {
        double discretization = this.discretization;
        return new Int3D((int)(location.x / discretization), (int)(location.y / discretization), (int)(location.z / discretization));
    }

    public final Int3D discretize(Double3D location, int discretization) {
        return new Int3D((int)(location.x / (double)discretization), (int)(location.y / (double)discretization), (int)(location.z / (double)discretization));
    }

    public final boolean setObjectLocation(Object obj, Double3D location) {
        boolean result = super.setObjectLocation(obj, this.discretize(location));
        if (result) {
            this.doubleLocationHash.put(obj, location);
        }
        return result;
    }

    @Override
    public final Bag clear() {
        this.doubleLocationHash = this.buildMap(0);
        return super.clear();
    }

    @Override
    public final Object remove(Object obj) {
        Object result = super.remove(obj);
        this.doubleLocationHash.remove(obj);
        return result;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getLength() {
        return this.length;
    }

    public final double tx(double x) {
        double width = this.width;
        if (x >= 0.0 && x < width) {
            return x;
        }
        if ((x %= width) < 0.0) {
            x += width;
        }
        return x;
    }

    public final double ty(double y) {
        double height = this.height;
        if (y >= 0.0 && y < height) {
            return y;
        }
        if ((y %= height) < 0.0) {
            y += height;
        }
        return y;
    }

    public final double tz(double z) {
        double length = this.length;
        if (z >= 0.0 && z < length) {
            return z;
        }
        if ((z %= length) < 0.0) {
            z += length;
        }
        return z;
    }

    public double stx(double x) {
        if (x >= 0.0) {
            if (x < this.width) {
                return x;
            }
            return x - this.width;
        }
        return x + this.width;
    }

    public double sty(double y) {
        if (y >= 0.0) {
            if (y < this.height) {
                return y;
            }
            return y - this.height;
        }
        return y + this.height;
    }

    public double stz(double z) {
        if (z >= 0.0) {
            if (z < this.length) {
                return z;
            }
            return z - this.length;
        }
        return z + this.length;
    }

    double stx(double x, double width) {
        if (x >= 0.0) {
            if (x < width) {
                return x;
            }
            return x - width;
        }
        return x + width;
    }

    public double tdx(double x1, double x2) {
        double width = this.width;
        if (Math.abs(x1 - x2) <= width / 2.0) {
            return x1 - x2;
        }
        double dx = this.stx(x1, width) - this.stx(x2, width);
        if (dx * 2.0 > width) {
            return dx - width;
        }
        if (dx * 2.0 < -width) {
            return dx + width;
        }
        return dx;
    }

    double sty(double y, double height) {
        if (y >= 0.0) {
            if (y < height) {
                return y;
            }
            return y - height;
        }
        return y + height;
    }

    public double tdy(double y1, double y2) {
        double height = this.height;
        if (Math.abs(y1 - y2) <= height / 2.0) {
            return y1 - y2;
        }
        double dy = this.sty(y1, height) - this.sty(y2, height);
        if (dy * 2.0 > height) {
            return dy - height;
        }
        if (dy * 2.0 < -height) {
            return dy + height;
        }
        return dy;
    }

    double stz(double z, double length) {
        if (z >= 0.0) {
            if (z < length) {
                return z;
            }
            return z - length;
        }
        return z + length;
    }

    public double tdz(double z1, double z2) {
        double length = this.length;
        if (Math.abs(z1 - z2) <= length / 2.0) {
            return z1 - z2;
        }
        double dz = this.stz(z1, length) - this.stz(z2, length);
        if (dz * 2.0 > length) {
            return dz - length;
        }
        if (dz * 2.0 < -length) {
            return dz + length;
        }
        return dz;
    }

    public double tds(Double3D d1, Double3D d2) {
        double dx = this.tdx(d1.x, d2.x);
        double dy = this.tdy(d1.y, d2.y);
        double dz = this.tdz(d1.z, d2.z);
        return dx * dx + dy * dy + dz * dz;
    }

    public Double3D tv(Double3D d1, Double3D d2) {
        return new Double3D(this.tdx(d1.x, d2.x), this.tdy(d1.y, d2.y), this.tdz(d1.z, d2.z));
    }

    public Bag getObjectsExactlyWithinDistance(Double3D position, double distance) {
        return this.getObjectsExactlyWithinDistance(position, distance, false, true, true, null);
    }

    public Bag getObjectsExactlyWithinDistance(Double3D position, double distance, boolean toroidal) {
        return this.getObjectsExactlyWithinDistance(position, distance, toroidal, true, true, null);
    }

    public Bag getObjectsExactlyWithinDistance(Double3D position, double distance, boolean toroidal, boolean radial, boolean inclusive, Bag result) {
        return this.getNeighborsExactlyWithinDistance(position, distance, toroidal, radial, inclusive, result);
    }

    public Bag getNeighborsExactlyWithinDistance(Double3D position, double distance) {
        return this.getObjectsExactlyWithinDistance(position, distance, false, true, true, null);
    }

    public Bag getNeighborsExactlyWithinDistance(Double3D position, double distance, boolean toroidal) {
        return this.getNeighborsExactlyWithinDistance(position, distance, toroidal, true, true, null);
    }

    public Bag getNeighborsExactlyWithinDistance(Double3D position, double distance, boolean toroidal, boolean radial, boolean inclusive, Bag result) {
        result = this.getNeighborsWithinDistance(position, distance, toroidal, false, result);
        int numObjs = result.numObjs;
        Object[] objs = result.objs;
        double distsq = distance * distance;
        if (radial) {
            int i = 0;
            while (i < numObjs) {
                double d = 0.0;
                Double3D loc = this.getObjectLocation(objs[i]);
                d = toroidal ? this.tds(position, loc) : position.distanceSq(loc);
                if (d > distsq || !inclusive && d >= distsq) {
                    result.remove(i);
                    --i;
                    --numObjs;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < numObjs) {
                Double3D loc = this.getObjectLocation(objs[i]);
                double minx = 0.0;
                double miny = 0.0;
                double minz = 0.0;
                if (toroidal) {
                    minx = this.tdx(loc.x, position.x);
                    miny = this.tdy(loc.y, position.y);
                    minz = this.tdz(loc.z, position.z);
                } else {
                    minx = loc.x - position.x;
                    miny = loc.y - position.y;
                    minz = loc.z - position.z;
                }
                if (minx < 0.0) {
                    minx = -minx;
                }
                if (miny < 0.0) {
                    miny = -miny;
                }
                if (minz < 0.0) {
                    minz = -minz;
                }
                if (minx > distance || miny > distance || minz > distance || !inclusive && (minx >= distance || miny >= distance || minz >= distance)) {
                    result.remove(i);
                    --i;
                    --numObjs;
                }
                ++i;
            }
        }
        return result;
    }

    public Bag getObjectsWithinDistance(Double3D position, double distance) {
        return this.getObjectsWithinDistance(position, distance, false, false, new Bag());
    }

    public Bag getObjectsWithinDistance(Double3D position, double distance, boolean toroidal) {
        return this.getObjectsWithinDistance(position, distance, toroidal, false, new Bag());
    }

    public Bag getObjectsWithinDistance(Double3D position, double distance, boolean toroidal, boolean nonPointObjects) {
        return this.getObjectsWithinDistance(position, distance, toroidal, nonPointObjects, new Bag());
    }

    public Bag getObjectsWithinDistance(Double3D position, double distance, boolean toroidal, boolean nonPointObjects, Bag result) {
        return this.getNeighborsWithinDistance(position, distance, toroidal, nonPointObjects, result);
    }

    public Bag getNeighborsWithinDistance(Double3D position, double distance) {
        return this.getNeighborsWithinDistance(position, distance, false, false, new Bag());
    }

    public Bag getNeighborsWithinDistance(Double3D position, double distance, boolean toroidal) {
        return this.getNeighborsWithinDistance(position, distance, toroidal, false, new Bag());
    }

    public Bag getNeighborsWithinDistance(Double3D position, double distance, boolean toroidal, boolean nonPointObjects) {
        return this.getNeighborsWithinDistance(position, distance, toroidal, nonPointObjects, new Bag());
    }

    public Bag getNeighborsWithinDistance(Double3D position, double distance, boolean toroidal, boolean nonPointObjects, Bag result) {
        if (toroidal && (position.x >= this.width || position.y >= this.height || position.z >= this.length || position.x < 0.0 || position.y < 0.0 || position.z < 0.0)) {
            position = new Double3D(this.tx(position.x), this.ty(position.y), this.tz(position.z));
        }
        double discDistance = distance / this.discretization;
        double discX = position.x / this.discretization;
        double discY = position.y / this.discretization;
        double discZ = position.z / this.discretization;
        if (nonPointObjects) {
            discDistance += 1.0;
        }
        boolean expectedBagSize = true;
        if (result != null) {
            result.clear();
        } else {
            result = new Bag(1);
        }
        MutableInt3D speedyMutableInt3D = this.speedyMutableInt3D;
        if (toroidal) {
            int iWidth = (int)StrictMath.ceil(this.width / this.discretization);
            int iHeight = (int)StrictMath.ceil(this.height / this.discretization);
            int iLength = (int)StrictMath.ceil(this.length / this.discretization);
            int minX = (int)StrictMath.floor(discX - discDistance);
            int maxX = (int)StrictMath.floor(discX + discDistance);
            int minY = (int)StrictMath.floor(discY - discDistance);
            int maxY = (int)StrictMath.floor(discY + discDistance);
            int minZ = (int)StrictMath.floor(discZ - discDistance);
            int maxZ = (int)StrictMath.floor(discZ + discDistance);
            if (position.x + distance >= this.width && maxX == iWidth - 1) {
                maxX = 0;
            }
            if (position.y + distance >= this.height && maxY == iHeight - 1) {
                maxY = 0;
            }
            if (position.z + distance >= this.length && maxZ == iLength - 1) {
                maxZ = 0;
            }
            if ((long)maxX - (long)minX >= (long)iWidth) {
                minX = 0;
                maxX = iWidth - 1;
            }
            if ((long)maxY - (long)minY >= (long)iHeight) {
                minY = 0;
                maxY = iHeight - 1;
            }
            if ((long)maxZ - (long)minZ >= (long)iLength) {
                minZ = 0;
                maxZ = iLength - 1;
            }
            int tmaxX = this.toroidal(maxX, iWidth);
            int tmaxY = this.toroidal(maxY, iHeight);
            int tmaxZ = this.toroidal(maxZ, iLength);
            int tminX = this.toroidal(minX, iWidth);
            int tminY = this.toroidal(minY, iHeight);
            int tminZ = this.toroidal(minZ, iLength);
            int x = tminX;
            while (true) {
                int y = tminY;
                while (true) {
                    int z = tminZ;
                    while (true) {
                        speedyMutableInt3D.x = ++x;
                        speedyMutableInt3D.y = ++y;
                        speedyMutableInt3D.z = ++z;
                        Bag temp = this.getRawObjectsAtLocation(speedyMutableInt3D);
                        if (temp != null && !temp.isEmpty()) {
                            int n = temp.numObjs;
                            if (n == 1) {
                                result.add(temp.objs[0]);
                            } else {
                                result.addAll(temp);
                            }
                        }
                        if (z == tmaxZ) break;
                        if (z != iLength - 1) continue;
                        z = 0;
                    }
                    if (y == tmaxY) break;
                    if (y != iHeight - 1) continue;
                    y = 0;
                }
                if (x != tmaxX) {
                    if (x != iWidth - 1) continue;
                    x = 0;
                    continue;
                }
                break;
            }
        } else {
            int minX = (int)StrictMath.floor(discX - discDistance);
            int maxX = (int)StrictMath.floor(discX + discDistance);
            int minY = (int)StrictMath.floor(discY - discDistance);
            int maxY = (int)StrictMath.floor(discY + discDistance);
            int minZ = (int)StrictMath.floor(discZ - discDistance);
            int maxZ = (int)StrictMath.floor(discZ + discDistance);
            int x = minX;
            while (x <= maxX) {
                int y = minY;
                while (y <= maxY) {
                    int z = minZ;
                    while (z <= maxZ) {
                        speedyMutableInt3D.x = x;
                        speedyMutableInt3D.y = y;
                        speedyMutableInt3D.z = z;
                        Bag temp = this.getRawObjectsAtLocation(speedyMutableInt3D);
                        if (temp != null && !temp.isEmpty()) {
                            int n = temp.numObjs;
                            if (n == 1) {
                                result.add(temp.objs[0]);
                            } else {
                                result.addAll(temp);
                            }
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        }
        return result;
    }

    final int toroidal(int x, int width) {
        if (x >= 0) {
            return x % width;
        }
        int width2 = x % width + width;
        if (width2 < width) {
            return width2;
        }
        return 0;
    }

    public Bag getObjectsAtDiscretizedLocation(Int3D location) {
        return this.getRawObjectsAtLocation(location);
    }

    public Bag getObjectsAtLocation(Double3D location) {
        if (location == null) {
            return null;
        }
        Bag cell = this.getRawObjectsAtLocation(this.discretize(location));
        if (cell == null) {
            return null;
        }
        Bag result = new Bag();
        Object[] objs = cell.objs;
        int numObjs = cell.numObjs;
        int i = 0;
        while (i < numObjs) {
            Double3D loc = this.getObjectLocation(objs[i]);
            if (((Object)loc).equals(location)) {
                result.add(objs[i]);
            }
            ++i;
        }
        return result;
    }

    public int numObjectsAtLocation(Double3D location) {
        if (location == null) {
            return 0;
        }
        Bag cell = this.getRawObjectsAtLocation(this.discretize(location));
        if (cell == null) {
            return 0;
        }
        int count = 0;
        Object[] objs = cell.objs;
        int numObjs = cell.numObjs;
        int i = 0;
        while (i < numObjs) {
            Double3D loc = this.getObjectLocation(objs[i]);
            if (((Object)loc).equals(location)) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    @Override
    public Bag getObjectsAtLocationOfObject(Object obj) {
        Double3D location = this.getObjectLocation(obj);
        if (location == null) {
            return null;
        }
        return this.getObjectsAtLocation((Object)location);
    }

    @Override
    public int numObjectsAtLocationOfObject(Object obj) {
        Double3D location = this.getObjectLocation(obj);
        if (location == null) {
            return 0;
        }
        return this.numObjectsAtLocation((Object)location);
    }

    public Bag removeObjectsAtLocation(Double3D location) {
        Bag bag = this.getObjectsAtLocation(location);
        if (bag != null) {
            Object[] objs = bag.objs;
            int numObjs = bag.numObjs;
            int i = 0;
            while (i < bag.numObjs) {
                this.remove(objs[i]);
                ++i;
            }
        }
        return bag;
    }

    @Override
    public final Double3D getDimensions() {
        return new Double3D(this.width, this.height, this.length);
    }

    @Override
    public Double3D getObjectLocationAsDouble3D(Object obj) {
        return (Double3D)this.doubleLocationHash.get(obj);
    }
}

