/*
 * Decompiled with CFR 0.152.
 */
package sim.engine;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.WeakReference;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.engine.Stoppable;

public class WeakStep
implements Steppable {
    private static final long serialVersionUID = 1L;
    WeakReference weakStep;
    Stoppable stop;

    private void writeObject(ObjectOutputStream p) throws IOException {
        p.writeObject(this.weakStep.get());
        p.writeBoolean(this.stop != null);
        if (this.stop != null) {
            p.writeObject(this.stop);
        }
    }

    private void readObject(ObjectInputStream p) throws IOException, ClassNotFoundException {
        this.weakStep = new WeakReference<Object>(p.readObject());
        this.stop = p.readBoolean() ? (Stoppable)p.readObject() : null;
    }

    public WeakStep(Steppable step) {
        this.weakStep = new WeakReference<Steppable>(step);
    }

    public void setStoppable(Stoppable stop) {
        this.stop = stop;
    }

    @Override
    public void step(SimState state) {
        Steppable step = (Steppable)this.weakStep.get();
        if (step != null) {
            step.step(state);
        } else if (this.stop != null) {
            this.stop.stop();
        }
    }
}

