/*
 * Decompiled with CFR 0.152.
 */
package sim.engine;

import java.util.Collection;
import java.util.LinkedHashSet;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.util.Bag;

public class Sequence
implements Steppable {
    private static final long serialVersionUID = 1L;
    protected Steppable[] steps;
    protected int size;
    LinkedHashSet stepsHash = null;
    Bag toBeRemoved = new Bag();
    Bag toBeAdded = new Bag();
    Steppable[] toReplace = null;
    boolean ensuresOrder = false;

    public Sequence(Steppable[] steps) {
        this.steps = (Steppable[])steps.clone();
        this.size = steps.length;
    }

    public Sequence(Collection collection) {
        this.steps = new Steppable[collection.size()];
        this.steps = collection.toArray(this.steps);
    }

    public boolean getEnsuresOrder() {
        return this.ensuresOrder;
    }

    public void setEnsuresOrder(boolean val) {
        this.ensuresOrder = val;
    }

    protected boolean canEnsureOrder() {
        return true;
    }

    public boolean getUsesSets() {
        return this.stepsHash != null;
    }

    public void setUsesSets(boolean val) {
        if (val && this.stepsHash == null) {
            this.stepsHash = new LinkedHashSet();
            int i = 0;
            while (i < this.size) {
                if (!this.stepsHash.add(this.steps[i])) {
                    throw new RuntimeException("This Sequence is set up to use Sets, but duplicate Steppables were added to the sequence, which is not permitted in this mode.");
                }
                ++i;
            }
        } else if (!val && this.stepsHash != null) {
            this.stepsHash = null;
        }
    }

    void loadStepsSet() {
        int toBeAddedSize;
        int toBeRemovedSize;
        boolean stepsHashChanged = false;
        if (this.toReplace != null) {
            stepsHashChanged = true;
            this.stepsHash.clear();
            int i = 0;
            while (i < this.toReplace.length) {
                if (!this.stepsHash.add(this.toReplace[i])) {
                    throw new RuntimeException("This Sequence is set up to use Sets, but duplicate Steppables were added to the sequence, which is not permitted in this mode.");
                }
                ++i;
            }
            this.size = this.toReplace.length;
            this.toReplace = null;
        }
        if ((toBeRemovedSize = this.toBeRemoved.size()) > 0) {
            stepsHashChanged = true;
            int i = 0;
            while (i < toBeRemovedSize) {
                this.stepsHash.remove(this.toBeRemoved.get(i));
                ++i;
            }
            this.toBeRemoved.clear();
        }
        if ((toBeAddedSize = this.toBeAdded.size()) > 0) {
            stepsHashChanged = true;
            int i = 0;
            while (i < toBeAddedSize) {
                this.stepsHash.add(this.toBeAdded.get(i));
                ++i;
            }
            this.toBeAdded.clear();
        }
        if (stepsHashChanged) {
            if (this.steps == null) {
                this.steps = new Steppable[this.stepsHash.size()];
            }
            this.steps = this.stepsHash.toArray(this.steps);
            this.size = this.steps.length;
        }
    }

    protected void loadSteps() {
        int toBeAddedSize;
        int toBeRemovedSize;
        if (this.stepsHash != null) {
            this.loadStepsSet();
            return;
        }
        if (this.toReplace != null) {
            this.steps = this.toReplace;
            this.size = this.steps.length;
            this.toReplace = null;
        }
        if ((toBeRemovedSize = this.toBeRemoved.size()) > 0) {
            boolean ensuresOrder = this.ensuresOrder && this.canEnsureOrder();
            Steppable[] steps = this.steps;
            Bag toBeRemoved = this.toBeRemoved;
            int stepsSize = this.size;
            int s = stepsSize - 1;
            while (s >= 0) {
                int r = 0;
                while (r < toBeRemovedSize) {
                    if (steps[s] == toBeRemoved.get(r)) {
                        if (s < stepsSize - 1) {
                            if (ensuresOrder) {
                                System.arraycopy(steps, s + 1, steps, s, stepsSize - s - 1);
                            } else {
                                steps[s] = steps[stepsSize - 1];
                            }
                        }
                        steps[stepsSize - 1] = null;
                        --stepsSize;
                        toBeRemoved.remove(r);
                        --toBeRemovedSize;
                        break;
                    }
                    ++r;
                }
                if (toBeRemovedSize == 0) break;
                --s;
            }
            toBeRemoved.clear();
            this.size = stepsSize;
        }
        if ((toBeAddedSize = this.toBeAdded.size()) > 0) {
            Bag toBeAdded = this.toBeAdded;
            int stepsSize = this.size;
            int newLen = stepsSize + toBeAddedSize;
            if (newLen >= this.steps.length) {
                int newSize = this.steps.length * 2 + 1;
                if (newSize <= newLen) {
                    newSize = newLen;
                }
                Steppable[] newSteppables = new Steppable[newSize];
                System.arraycopy(this.steps, 0, newSteppables, 0, this.steps.length);
                this.steps = newSteppables;
                this.steps = newSteppables;
            }
            if (toBeAddedSize < 20) {
                int i = 0;
                while (i < toBeAddedSize) {
                    this.steps[stepsSize + i] = (Steppable)toBeAdded.get(i);
                    ++i;
                }
            } else {
                toBeAdded.copyIntoArray(0, this.steps, stepsSize, toBeAddedSize);
            }
            toBeAdded.clear();
            this.size = newLen;
        }
    }

    public void replaceSteppables(Collection collection) {
        if (this.toReplace == null) {
            this.toReplace = new Steppable[collection.size()];
        }
        this.toReplace = collection.toArray(this.toReplace);
    }

    public void replaceSteppables(Steppable[] steppables) {
        this.toReplace = (Steppable[])steppables.clone();
    }

    public void addSteppable(Steppable steppable) {
        this.toBeAdded.add(steppable);
    }

    public void addSteppables(Steppable[] steppables) {
        this.toBeAdded.addAll(steppables);
    }

    public void addSteppables(Collection steppables) {
        this.toBeAdded.addAll(steppables);
    }

    public void removeSteppable(Steppable steppable) {
        this.toBeRemoved.add(steppable);
    }

    public void removeSteppables(Steppable[] steppables) {
        this.toBeRemoved.addAll(steppables);
    }

    public void removeSteppables(Collection steppables) {
        this.toBeRemoved.addAll(steppables);
    }

    @Override
    public void step(SimState state) {
        this.loadSteps();
        int stepsSize = this.size;
        Steppable[] steps = this.steps;
        int x = 0;
        while (x < stepsSize) {
            if (steps[x] != null) {
                steps[x].step(state);
            }
            ++x;
        }
    }
}

