/*
 * Decompiled with CFR 0.152.
 */
package sim.engine;

import sim.engine.Schedule;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.engine.Stoppable;
import sim.util.LocationLog;

public abstract class Repeat
implements Steppable,
Stoppable {
    Steppable step;
    Schedule.Key key = null;
    int ordering;

    public Repeat(Steppable step, int ordering) {
        this.step = step;
        this.ordering = ordering;
    }

    protected abstract double getNextTime(SimState var1, double var2);

    public synchronized void setOrdering(int val) {
        this.ordering = val;
    }

    public synchronized int getOrdering() {
        return this.ordering;
    }

    @Override
    public synchronized void step(SimState state) {
        if (this.step != null) {
            try {
                if (this.key == null) {
                    this.key = new Schedule.Key(state.schedule.getTime(), this.ordering);
                }
                this.key.time = this.getNextTime(state, this.key.time);
                if (!(this.key.time < Double.POSITIVE_INFINITY)) {
                    return;
                }
                state.schedule.scheduleOnce(this.key, (Steppable)this);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            assert (LocationLog.set(this.step));
            this.step.step(state);
            assert (LocationLog.clear());
        }
    }

    @Override
    public synchronized void stop() {
        this.step = null;
    }

    public String toString() {
        return "Repeat[" + this.step + "]";
    }
}

