/*
 * Decompiled with CFR 0.152.
 */
package sim.engine;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import sim.engine.SimState;
import sim.engine.Steppable;

public class MethodStep
implements Steppable {
    private static final long serialVersionUID = 1L;
    Method method;
    Object object;
    boolean passInSimState;

    public MethodStep(Object object, String methodName) {
        this(object, methodName, false);
    }

    public MethodStep(Object object, String methodName, boolean passInSimState) {
        this.object = object;
        this.passInSimState = passInSimState;
        if (object == null) {
            throw new NullPointerException("MethodStep asked to call the method " + methodName + (passInSimState ? "\"(SimState state)" : "\"") + " on a null object");
        }
        try {
            this.method = passInSimState ? object.getClass().getMethod(methodName, SimState.class) : object.getClass().getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException("Could not find a public method called \"" + methodName + (passInSimState ? "\"(SimState state)" : "\"") + " in the class " + object.getClass());
        }
        catch (SecurityException ex) {
            throw new RuntimeException("Could not find a public method called \"" + methodName + (passInSimState ? "\"(SimState state)" : "\"") + " in the class " + object.getClass());
        }
    }

    @Override
    public void step(SimState state) {
        try {
            if (this.passInSimState) {
                this.method.invoke(this.object, state);
            } else {
                this.method.invoke(this.object, null);
            }
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Could not find a public method called \"" + this.method + (this.passInSimState ? "\"(SimState state)" : "\"") + " in the class " + this.object.getClass());
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException("Could not find a public method called \"" + this.method + (this.passInSimState ? "\"(SimState state)" : "\"") + " in the class " + this.object.getClass());
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException("On calling \"" + this.method + (this.passInSimState ? "\"(SimState state)" : "\"") + " in the class " + this.object.getClass() + ", an Exception was raised in the called method.", ex);
        }
        catch (NullPointerException ex) {
            throw new NullPointerException("MethodStep asked to call the method " + this.method + (this.passInSimState ? "\"(SimState state)" : "\"") + " on a null object");
        }
    }
}

