/*
 * Decompiled with CFR 0.152.
 */
package sim.display;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import sim.display.Console;
import sim.display.Display2D;
import sim.display.GUIState;

public class SimApplet
extends Applet {
    private static boolean b = Display2D.isMacOSX();
    private static int i = 380;
    public static boolean isApplet = false;

    public SimApplet() {
        isApplet = true;
    }

    @Override
    public void init() {
        String simClassName = this.getParameter("Simulation");
        String simHumanName = this.getParameter("Name");
        final JButton button = new JButton("Start " + simHumanName);
        this.setLayout(new BorderLayout());
        this.add((Component)button, "Center");
        try {
            final Class<?> simClass = Class.forName(simClassName);
            if (!GUIState.class.isAssignableFrom(simClass) && !simClass.equals(Console.class)) {
                throw new Exception("Class is not a GUIState or the Console: " + simClass);
            }
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    try {
                        SimApplet.this.setupApplet(simClass);
                    }
                    catch (Exception e) {
                        SimApplet.this.doException(button, e);
                    }
                }
            });
        }
        catch (Exception e) {
            this.doException(button, e);
        }
    }

    public void setupApplet(Class GUIStateClass) throws Exception {
        if (GUIStateClass.equals(Console.class)) {
            Console.main(new String[0]);
        } else {
            GUIState state = (GUIState)GUIStateClass.newInstance();
            state.createController();
        }
    }

    public void doException(JComponent button, Exception e) {
        JTextArea text = new JTextArea();
        text.setText("" + e);
        JScrollPane scroll = new JScrollPane(text);
        if (button != null) {
            this.remove(button);
        }
        this.add((Component)scroll, "Center");
        e.printStackTrace();
    }
}

