/*
 * Decompiled with CFR 0.152.
 */
package sim.display;

import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import sim.display.GUIState;

public class Prefs {
    public static final String MASON_PREFERENCES = "edu/gmu/mason/global/";
    public static final String APP_PREFERENCES = "edu/gmu/mason/app/";

    public static Preferences getGlobalPreferences(String namespace) {
        return Preferences.userRoot().node(MASON_PREFERENCES + namespace);
    }

    public static Preferences getAppPreferences(GUIState simulation, String namespace) {
        return Preferences.userRoot().node(APP_PREFERENCES + simulation.getClass().getName().replace('.', '/') + "/" + namespace);
    }

    public static boolean removeGlobalPreferences(String namespace) {
        try {
            Prefs.getGlobalPreferences(namespace).removeNode();
            return true;
        }
        catch (BackingStoreException e) {
            return false;
        }
    }

    public static boolean removeAppPreferences(GUIState simulation, String namespace) {
        try {
            Prefs.getAppPreferences(simulation, namespace).removeNode();
            return true;
        }
        catch (BackingStoreException e) {
            return false;
        }
    }

    public static boolean save(Preferences prefs) {
        try {
            prefs.flush();
            return true;
        }
        catch (BackingStoreException ex) {
            return false;
        }
    }
}

