/*
 * Decompiled with CFR 0.152.
 */
package sim.app.woims;

import java.io.Serializable;
import sim.util.Double2D;

public class Vector2D
implements Serializable {
    private static final long serialVersionUID = 1L;
    public double x;
    public double y;

    public Vector2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Vector2D(Double2D d) {
        this.x = d.x;
        this.y = d.y;
    }

    public final Vector2D add(Vector2D b) {
        return new Vector2D(this.x + b.x, this.y + b.y);
    }

    public final Vector2D add(Double2D b) {
        return new Vector2D(this.x + b.x, this.y + b.y);
    }

    public final Vector2D subtract(Vector2D b) {
        return new Vector2D(this.x - b.x, this.y - b.y);
    }

    public final Vector2D subtract(Double2D b) {
        return new Vector2D(this.x - b.x, this.y - b.y);
    }

    public final Vector2D amplify(double alpha) {
        return new Vector2D(this.x * alpha, this.y * alpha);
    }

    public final Vector2D normalize() {
        if (this.x != 0.0 || this.y != 0.0) {
            double temp = Math.sqrt(this.x * this.x + this.y * this.y);
            return new Vector2D(this.x / temp, this.y / temp);
        }
        return new Vector2D(0.0, 0.0);
    }

    public final double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public final Vector2D setLength(double dist) {
        if (dist == 0.0) {
            return new Vector2D(0.0, 0.0);
        }
        if (this.x == 0.0 && this.y == 0.0) {
            return new Vector2D(0.0, 0.0);
        }
        double temp = Math.sqrt(this.x * this.x + this.y * this.y);
        return new Vector2D(this.x * dist / temp, this.y * dist / temp);
    }
}

