/*
 * Decompiled with CFR 0.152.
 */
package sim.app.wcss.tutorial10;

import sim.app.wcss.tutorial10.Student;
import sim.engine.SimState;
import sim.field.continuous.Continuous2D;
import sim.field.network.Network;
import sim.util.Bag;
import sim.util.Double2D;
import sim.util.Interval;

public class Students
extends SimState {
    private static final long serialVersionUID = 1L;
    public Continuous2D yard = new Continuous2D(1.0, 100.0, 100.0);
    public int numStudents = 50;
    double forceToSchoolMultiplier = 0.01;
    double randomMultiplier = 0.1;
    public Network buddies = new Network(false);

    public int getNumStudents() {
        return this.numStudents;
    }

    public void setNumStudents(int val) {
        if (val > 0) {
            this.numStudents = val;
        }
    }

    public double getForceToSchoolMultiplier() {
        return this.forceToSchoolMultiplier;
    }

    public void setForceToSchoolMultiplier(double val) {
        if (this.forceToSchoolMultiplier >= 0.0) {
            this.forceToSchoolMultiplier = val;
        }
    }

    public double getRandomMultiplier() {
        return this.randomMultiplier;
    }

    public void setRandomMultiplier(double val) {
        if (this.randomMultiplier >= 0.0) {
            this.randomMultiplier = val;
        }
    }

    public Object domRandomMultiplier() {
        return new Interval(0.0, 100.0);
    }

    public double[] getAgitationDistribution() {
        Bag students = this.buddies.getAllNodes();
        double[] distro = new double[students.numObjs];
        int len = students.size();
        int i = 0;
        while (i < len) {
            distro[i] = ((Student)students.get(i)).getAgitation();
            ++i;
        }
        return distro;
    }

    public Students(long seed) {
        super(seed);
    }

    @Override
    public void start() {
        super.start();
        this.yard.clear();
        this.buddies.clear();
        int i = 0;
        while (i < this.numStudents) {
            Student student = new Student();
            this.yard.setObjectLocation((Object)student, new Double2D(this.yard.getWidth() * 0.5 + this.random.nextDouble() - 0.5, this.yard.getHeight() * 0.5 + this.random.nextDouble() - 0.5));
            this.buddies.addNode(student);
            this.schedule.scheduleRepeating(student);
            ++i;
        }
        Bag students = this.buddies.getAllNodes();
        int i2 = 0;
        while (i2 < students.size()) {
            Object student = students.get(i2);
            Object studentB = null;
            while (student == (studentB = students.get(this.random.nextInt(students.numObjs)))) {
            }
            double buddiness = this.random.nextDouble();
            this.buddies.addEdge(student, studentB, new Double(buddiness));
            while (student == (studentB = students.get(this.random.nextInt(students.numObjs)))) {
            }
            buddiness = this.random.nextDouble();
            this.buddies.addEdge(student, studentB, new Double(-buddiness));
            ++i2;
        }
    }

    public static void main(String[] args) {
        Students.doLoop(Students.class, args);
        System.exit(0);
    }
}

