/*
 * Decompiled with CFR 0.152.
 */
package sim.app.tutorial4;

import sim.app.tutorial4.Tutorial4;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.util.Bag;
import sim.util.Int2D;

public class Particle
implements Steppable {
    private static final long serialVersionUID = 1L;
    public boolean randomize = false;
    public int xdir;
    public int ydir;

    public int getXDir() {
        return this.xdir;
    }

    public int getYDir() {
        return this.ydir;
    }

    public boolean getRandomize() {
        return this.randomize;
    }

    public void setRandomize(boolean val) {
        this.randomize = val;
    }

    public Particle(int xdir, int ydir) {
        this.xdir = xdir;
        this.ydir = ydir;
    }

    @Override
    public void step(SimState state) {
        Tutorial4 tut = (Tutorial4)state;
        Int2D location = tut.particles.getObjectLocation(this);
        tut.trails.field[location.x][location.y] = 1.0;
        if (this.randomize) {
            this.xdir = tut.random.nextInt(3) - 1;
            this.ydir = tut.random.nextInt(3) - 1;
            this.randomize = false;
            ++tut.collisions;
        }
        int newx = location.x + this.xdir;
        int newy = location.y + this.ydir;
        if (newx < 0) {
            ++newx;
            this.xdir = -this.xdir;
        } else if (newx >= tut.trails.getWidth()) {
            --newx;
            this.xdir = -this.xdir;
        }
        if (newy < 0) {
            ++newy;
            this.ydir = -this.ydir;
        } else if (newy >= tut.trails.getHeight()) {
            --newy;
            this.ydir = -this.ydir;
        }
        Int2D newloc = new Int2D(newx, newy);
        tut.particles.setObjectLocation((Object)this, newloc);
        Bag p = tut.particles.getObjectsAtLocation(newloc);
        if (p.numObjs > 1) {
            int x = 0;
            while (x < p.numObjs) {
                ((Particle)p.objs[x]).randomize = true;
                ++x;
            }
        }
    }
}

