/*
 * Decompiled with CFR 0.152.
 */
package sim.app.tutorial3;

import sim.app.tutorial3.Particle;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.field.grid.DoubleGrid2D;
import sim.field.grid.SparseGrid2D;
import sim.util.Int2D;

public class Tutorial3
extends SimState {
    private static final long serialVersionUID = 1L;
    public DoubleGrid2D trails;
    public SparseGrid2D particles;
    public int gridWidth = 100;
    public int gridHeight = 100;
    public int numParticles = 500;

    public Tutorial3(long seed) {
        super(seed);
    }

    @Override
    public void start() {
        super.start();
        this.trails = new DoubleGrid2D(this.gridWidth, this.gridHeight);
        this.particles = new SparseGrid2D(this.gridWidth, this.gridHeight);
        int i = 0;
        while (i < this.numParticles) {
            Particle p = new Particle(this.random.nextInt(3) - 1, this.random.nextInt(3) - 1);
            this.schedule.scheduleRepeating(p);
            this.particles.setObjectLocation((Object)p, new Int2D(this.random.nextInt(this.gridWidth), this.random.nextInt(this.gridHeight)));
            ++i;
        }
        Steppable decreaser = new Steppable(){
            private static final long serialVersionUID = 1L;

            @Override
            public void step(SimState state) {
                Tutorial3.this.trails.multiply(0.9);
            }
        };
        this.schedule.scheduleRepeating(0.0, 2, decreaser, 1.0);
    }

    public static void main(String[] args) {
        Tutorial3.doLoop(Tutorial3.class, args);
        System.exit(0);
    }
}

