/*
 * Decompiled with CFR 0.152.
 */
package sim.app.swarmgame;

import java.awt.Color;
import javax.swing.JFrame;
import sim.app.swarmgame.SwarmGame;
import sim.display.Controller;
import sim.display.Display2D;
import sim.display.GUIState;
import sim.engine.SimState;
import sim.portrayal.continuous.ContinuousPortrayal2D;
import sim.portrayal.simple.OrientedPortrayal2D;
import sim.portrayal.simple.OvalPortrayal2D;

public class SwarmGameWithUI
extends GUIState {
    public Display2D display;
    public JFrame displayFrame;
    ContinuousPortrayal2D agentsPortrayal = new ContinuousPortrayal2D();

    public static void main(String[] args) {
        new SwarmGameWithUI().createController();
    }

    @Override
    public Object getSimulationInspectedObject() {
        return this.state;
    }

    public SwarmGameWithUI() {
        super(new SwarmGame(System.currentTimeMillis()));
    }

    public SwarmGameWithUI(SimState state) {
        super(state);
    }

    public static String getName() {
        return "The Swarm Game";
    }

    @Override
    public void start() {
        super.start();
        this.setupPortrayals();
    }

    @Override
    public void load(SimState state) {
        super.load(state);
        this.setupPortrayals();
    }

    public void setupPortrayals() {
        SwarmGame swarm = (SwarmGame)this.state;
        this.agentsPortrayal.setField(swarm.agents);
        this.agentsPortrayal.setPortrayalForAll(new OrientedPortrayal2D(new OvalPortrayal2D(Color.black), 0, 1.0));
        this.display.reset();
        this.display.setBackdrop(Color.white);
        this.display.repaint();
    }

    @Override
    public void init(Controller c) {
        super.init(c);
        this.display = new Display2D(500.0, 500.0, this);
        this.display.setClipping(false);
        this.displayFrame = this.display.createFrame();
        this.displayFrame.setTitle("Swarmers");
        c.registerFrame(this.displayFrame);
        this.displayFrame.setVisible(true);
        this.display.attach(this.agentsPortrayal, "Fear the Swarmers!");
    }

    @Override
    public void quit() {
        super.quit();
        if (this.displayFrame != null) {
            this.displayFrame.dispose();
        }
        this.displayFrame = null;
        this.display = null;
    }
}

