/*
 * Decompiled with CFR 0.152.
 */
package sim.app.pso;

import sim.app.pso.Evaluatable;
import sim.app.pso.PSO;
import sim.util.Double2D;
import sim.util.MutableDouble2D;

public class Particle {
    private static final long serialVersionUID = 1L;
    double bestVal = 0.0;
    MutableDouble2D bestPosition = new MutableDouble2D();
    MutableDouble2D position = new MutableDouble2D();
    MutableDouble2D velocity = new MutableDouble2D();
    PSO pso;
    Evaluatable fitnessFunction;
    int index;

    public Particle() {
    }

    public Particle(double x, double y, double vx, double vy, PSO pso, Evaluatable f, int index) {
        this.position.setTo(x, y);
        this.velocity.setTo(vx, vy);
        this.pso = pso;
        this.fitnessFunction = f;
        pso.space.setObjectLocation((Object)this, new Double2D(this.position));
        this.index = index;
    }

    public void updateBest(double currVal, double currX, double currY) {
        if (currVal > this.bestVal) {
            this.bestVal = currVal;
            this.bestPosition.setTo(currX, currY);
            this.pso.updateBest(currVal, currX, currY);
        }
    }

    public double getFitness() {
        return this.fitnessFunction.calcFitness(this.position.x, this.position.y);
    }

    public void stepUpdateFitness() {
        this.updateBest(this.getFitness(), this.position.x, this.position.y);
    }

    public void stepUpdateVelocity() {
        double x = this.position.x;
        double y = this.position.y;
        MutableDouble2D nBestPos = new MutableDouble2D();
        this.pso.getNeighborhoodBest(this.index, nBestPos);
        double inertia = this.velocity.x;
        double pDelta = this.bestPosition.x - x;
        double nDelta = nBestPos.x - x;
        double gDelta = this.pso.bestPosition.x - x;
        double pWeight = Math.random() + 0.4;
        double nWeight = Math.random() + 0.4;
        double gWeight = Math.random() + 0.4;
        double vx = (0.9 * inertia + pWeight * pDelta + nWeight * nDelta + gWeight * gDelta) / (1.0 + pWeight + nWeight + gWeight);
        inertia = this.velocity.y;
        pDelta = this.bestPosition.y - y;
        nDelta = nBestPos.y - y;
        gDelta = this.pso.bestPosition.y - y;
        pWeight = Math.random() + 0.4;
        nWeight = Math.random() + 0.4;
        gWeight = Math.random() + 0.4;
        double vy = (0.9 * inertia + pWeight * pDelta + nWeight * nDelta + gWeight * gDelta) / (1.0 + pWeight + nWeight + gWeight);
        this.velocity.setTo(vx *= this.pso.velocityScalar, vy *= this.pso.velocityScalar);
    }

    public void stepUpdatePosition() {
        this.position.addIn(this.velocity);
        this.pso.space.setObjectLocation((Object)this, new Double2D(this.position));
    }
}

