/*
 * Decompiled with CFR 0.152.
 */
package sim.app.particles3d;

import sim.app.particles3d.Particle;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.field.grid.DoubleGrid3D;
import sim.field.grid.SparseGrid3D;
import sim.util.Int3D;

public class Particles3D
extends SimState {
    private static final long serialVersionUID = 1L;
    public static int gridWidth = 30;
    public static int gridHeight = 30;
    public static int gridLength = 30;
    public SparseGrid3D particles;
    public DoubleGrid3D trails = new DoubleGrid3D(gridWidth, gridHeight, gridLength);
    public int numParticles = 20;

    public Particles3D(long seed) {
        super(seed);
    }

    @Override
    public void start() {
        super.start();
        this.particles = new SparseGrid3D(gridWidth, gridHeight, gridLength);
        this.trails = new DoubleGrid3D(gridWidth, gridHeight, gridLength);
        int i = 0;
        while (i < this.numParticles) {
            Particle p = new Particle(this.random.nextInt(3) - 1, this.random.nextInt(3) - 1, this.random.nextInt(3) - 1);
            this.schedule.scheduleRepeating(p);
            this.particles.setObjectLocation((Object)p, new Int3D(this.random.nextInt(gridWidth), this.random.nextInt(gridHeight), this.random.nextInt(gridLength)));
            ++i;
        }
        Steppable decreaser = new Steppable(){
            static final long serialVersionUID = 6330208160095250478L;

            @Override
            public void step(SimState state) {
                Particles3D.this.trails.multiply(0.9f);
            }
        };
        this.schedule.scheduleRepeating(0.0, 2, decreaser, 1.0);
    }

    public static void main(String[] args) {
        Particles3D.doLoop(Particles3D.class, args);
        System.exit(0);
    }
}

