/*
 * Decompiled with CFR 0.152.
 */
package sim.app.pacman;

import sim.app.pacman.Blinky;
import sim.app.pacman.Clyde;
import sim.app.pacman.Dot;
import sim.app.pacman.Energizer;
import sim.app.pacman.Inky;
import sim.app.pacman.Pac;
import sim.app.pacman.Pinky;
import sim.engine.SimState;
import sim.field.continuous.Continuous2D;
import sim.field.grid.IntGrid2D;
import sim.util.Double2D;
import sim.util.MutableDouble2D;
import sim.util.TableLoader;

public class PacMan
extends SimState {
    private static final long serialVersionUID = 1L;
    public Continuous2D agents;
    public Continuous2D dots;
    public IntGrid2D maze;
    boolean frightenGhosts;
    public int[] actions;
    public int deaths = 0;
    public int level = 1;
    public int score = 0;
    public Pac[] pacs;
    public int MAX_MAZES = 2;

    public PacMan(long seed) {
        super(seed);
    }

    @Override
    public void start() {
        super.start();
        this.deaths = 0;
        this.level = 1;
        this.score = 0;
        this.maze = new IntGrid2D(0, 0);
        try {
            this.maze.setTo(TableLoader.loadPNMFile(PacMan.class.getResourceAsStream("images/maze0.pbm")));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.agents = new Continuous2D(1.0, this.maze.getWidth(), this.maze.getHeight());
        this.dots = new Continuous2D(1.0, this.maze.getWidth(), this.maze.getHeight());
        this.resetGame();
    }

    public void resetGame() {
        this.dots.clear();
        try {
            this.maze.setTo(TableLoader.loadPNMFile(PacMan.class.getResourceAsStream("images/maze" + (this.level - 1) % this.MAX_MAZES + ".pbm")));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.dots.setObjectLocation((Object)new Energizer(), new Double2D(1.0, 5.0));
        this.dots.setObjectLocation((Object)new Energizer(), new Double2D(26.0, 5.0));
        this.dots.setObjectLocation((Object)new Energizer(), new Double2D(1.0, 25.0));
        this.dots.setObjectLocation((Object)new Energizer(), new Double2D(26.0, 25.0));
        int x = 0;
        while (x < this.maze.getWidth()) {
            int y = 0;
            while (y < this.maze.getHeight()) {
                if (this.maze.field[x][y] == 0 && (y != 16 || x < 12 || x > 16)) {
                    this.dots.setObjectLocation((Object)new Dot(), new Double2D(x, y));
                }
                ++y;
            }
            ++x;
        }
        this.resetAgents();
    }

    public int pacsLeft() {
        int count = 0;
        int i = 0;
        while (i < this.pacs.length) {
            if (this.pacs[i] != null) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public Pac pacClosestTo(MutableDouble2D location) {
        if (this.pacs.length == 1) {
            return this.pacs[0];
        }
        Pac best = null;
        int count = 1;
        int i = 0;
        while (i < this.pacs.length) {
            block5: {
                block6: {
                    block7: {
                        if (this.pacs[i] == null) break block5;
                        if (best == null) break block6;
                        if (!(best.location.distanceSq(location) > this.pacs[i].location.distanceSq(location))) break block7;
                        count = 1;
                        if (true) break block6;
                    }
                    if (best.location.distanceSq(location) != this.pacs[i].location.distanceSq(location) || !this.random.nextBoolean(1.0 / (double)(++count))) break block5;
                }
                best = this.pacs[i];
            }
            ++i;
        }
        return best;
    }

    public void resetAgents() {
        this.agents.clear();
        this.schedule.clear();
        this.actions = new int[]{-1, -1};
        this.pacs = new Pac[2];
        if (this.pacs.length > 1) {
            this.pacs[1] = new Pac(this, 1);
        }
        this.pacs[0] = new Pac(this, 0);
        Blinky blinky = new Blinky(this);
        Pinky pinky = new Pinky(this);
        Inky inky = new Inky(this, blinky);
        Clyde clyde = new Clyde(this);
        this.frightenGhosts = false;
    }

    public int getNextAction(int tag) {
        return this.actions[tag];
    }

    public static void main(String[] args) {
        PacMan.doLoop(PacMan.class, args);
        System.exit(0);
    }
}

