/*
 * Decompiled with CFR 0.152.
 */
package sim.app.pacman;

import sim.app.pacman.PacMan;
import sim.field.grid.IntGrid2D;
import sim.portrayal.Oriented2D;
import sim.util.Double2D;
import sim.util.MutableDouble2D;

public abstract class Agent
implements Oriented2D {
    private static final long serialVersionUID = 1L;
    public static final int N = 0;
    public static final int E = 1;
    public static final int S = 2;
    public static final int W = 3;
    public static final int NOTHING = -1;
    public int lastAction = -1;
    public MutableDouble2D location;
    PacMan pacman;
    public int discretization = 10;

    public double speed() {
        return 1.0 / (double)this.discretization;
    }

    public abstract Double2D getStartLocation();

    public Agent(PacMan pacman) {
        this.pacman = pacman;
        Double2D loc = this.getStartLocation();
        this.location = new MutableDouble2D(loc);
        pacman.agents.setObjectLocation((Object)this, loc);
    }

    @Override
    public double orientation2D() {
        switch (this.lastAction) {
            case 0: {
                return 4.71238898038469;
            }
            case 1: {
                return 0.0;
            }
            case 2: {
                return 1.5707963267948966;
            }
            case 3: {
                return Math.PI;
            }
        }
        return 0.0;
    }

    public void changeLocation(double x, double y) {
        this.location.x = (double)((int)Math.round(x * (double)this.discretization)) / (double)this.discretization;
        this.location.y = (double)((int)Math.round(y * (double)this.discretization)) / (double)this.discretization;
        this.pacman.agents.setObjectLocation((Object)this, new Double2D(this.location));
    }

    protected MutableDouble2D nextCell(int nextAction) {
        double nx = 0.0;
        double ny = 0.0;
        switch (nextAction) {
            case 0: {
                nx = this.location.x;
                ny = this.location.y - 1.0;
                break;
            }
            case 1: {
                nx = this.location.x + 1.0;
                ny = this.location.y;
                break;
            }
            case 2: {
                nx = this.location.x;
                ny = this.location.y + 1.0;
                break;
            }
            case 3: {
                nx = this.location.x - 1.0;
                ny = this.location.y;
            }
        }
        return new MutableDouble2D(nx, ny);
    }

    public void performAction(int action) {
        double x = this.location.x;
        double y = this.location.y;
        switch (action) {
            case 0: {
                y = this.pacman.agents.sty(y - this.speed());
                break;
            }
            case 1: {
                x = this.pacman.agents.stx(x + this.speed());
                break;
            }
            case 2: {
                y = this.pacman.agents.sty(y + this.speed());
                break;
            }
            case 3: {
                x = this.pacman.agents.stx(x - this.speed());
            }
        }
        this.changeLocation(x, y);
        this.lastAction = action;
    }

    public boolean isPossibleToDoAction(int action) {
        int y1;
        if (action == -1) {
            return false;
        }
        IntGrid2D maze = this.pacman.maze;
        int[][] field = maze.field;
        int x0 = (int)this.location.x;
        int y0 = (int)this.location.y;
        int x1 = this.location.x == (double)x0 ? x0 : x0 + 1;
        int n = y1 = this.location.y == (double)y0 ? y0 : y0 + 1;
        if (x0 == x1 && y0 == y1 || this.lastAction == -1) {
            switch (action) {
                case 0: {
                    return field[maze.stx(x0)][maze.sty(y0 - 1)] == 0;
                }
                case 1: {
                    return field[maze.stx(x0 + 1)][maze.sty(y0)] == 0;
                }
                case 2: {
                    return field[maze.stx(x0)][maze.sty(y0 + 1)] == 0;
                }
                case 3: {
                    return field[maze.stx(x0 - 1)][maze.sty(y0)] == 0;
                }
            }
        } else if (action == this.lastAction) {
            switch (action) {
                case 0: {
                    return field[maze.stx(x0)][maze.sty(y0)] == 0;
                }
                case 1: {
                    return field[maze.stx(x1)][maze.sty(y0)] == 0;
                }
                case 2: {
                    return field[maze.stx(x0)][maze.sty(y1)] == 0;
                }
                case 3: {
                    return field[maze.stx(x0)][maze.sty(y0)] == 0;
                }
            }
        } else if (action == 0 && this.lastAction == 2 || action == 2 && this.lastAction == 0 || action == 1 && this.lastAction == 3 || action == 3 && this.lastAction == 1) {
            return true;
        }
        return false;
    }
}

