/*
 * Decompiled with CFR 0.152.
 */
package sim.app.mousetraps;

import sim.app.mousetraps.Ball;
import sim.app.mousetraps.MouseTrap;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.field.continuous.Continuous3D;
import sim.field.grid.IntGrid2D;
import sim.util.Double3D;

public class MouseTraps
extends SimState {
    private static final long serialVersionUID = 1L;
    public static final int BALLS_PER_TRAP = 2;
    public final double initialVelocity;
    public static final double GRAVITY_ACC = 9.8;
    public static final double TWO_OVER_G = 0.2040816326530612;
    public static final double TIME_STEP_DURATION = 0.015625;
    public static final double TIME_STEP_FREQUENCY = 64.0;
    public static final double TWO_PI = Math.PI * 2;
    public static final double HALF_PI = 1.5707963267948966;
    public final boolean toroidalWorld;
    public final boolean modelBalls;
    public final int trapGridHeight;
    public final int trapGridWidth;
    public final double spaceWidth;
    public final double spaceHeight;
    public final double spaceLength;
    public final double oneOverSpaceWidth;
    public final double oneOverSpaceHeight;
    public final double oneOverSpaceLength;
    public final double trapSizeX;
    public final double trapSizeY;
    public IntGrid2D trapStateGrid;
    public Continuous3D ballSpace;
    public static final int ARMED_TRAP = 0;
    public static final int OFF_TRAP = 1;

    public MouseTraps(long seed) {
        this(seed, 0.7, 100, 100, true);
    }

    public MouseTraps(long seed, double initialVelocity, int width, int height, boolean toroidal) {
        super(seed);
        this.initialVelocity = initialVelocity;
        this.toroidalWorld = toroidal;
        this.modelBalls = false;
        this.trapGridWidth = width;
        this.trapGridHeight = height;
        this.spaceWidth = 1.0;
        this.spaceHeight = 1.0;
        this.spaceLength = 1.0;
        this.createGrids();
        this.trapSizeX = this.spaceWidth / (double)this.trapGridWidth;
        this.trapSizeY = this.spaceHeight / (double)this.trapGridHeight;
        this.oneOverSpaceHeight = 1.0 / this.spaceHeight;
        this.oneOverSpaceWidth = 1.0 / this.spaceWidth;
        this.oneOverSpaceLength = 1.0 / this.spaceLength;
    }

    public MouseTraps(long seed, double initialVelocity, int trapsX, int trapsY, double width, double height, boolean toroidal) {
        super(seed);
        this.initialVelocity = initialVelocity;
        this.toroidalWorld = toroidal;
        this.trapGridWidth = trapsX;
        this.trapGridHeight = trapsY;
        this.modelBalls = true;
        this.spaceWidth = width;
        this.spaceHeight = height;
        this.spaceLength = this.computeFishTankCeiling();
        this.createGrids();
        this.trapSizeX = this.spaceWidth / (double)this.trapGridWidth;
        this.trapSizeY = this.spaceHeight / (double)this.trapGridHeight;
        this.oneOverSpaceHeight = 1.0 / this.spaceHeight;
        this.oneOverSpaceWidth = 1.0 / this.spaceWidth;
        this.oneOverSpaceLength = 1.0 / this.spaceLength;
    }

    public double computeFishTankCeiling() {
        return 0.5 * this.initialVelocity * this.initialVelocity / 9.8;
    }

    void createGrids() {
        this.trapStateGrid = new IntGrid2D(this.trapGridWidth, this.trapGridHeight, 0);
        if (this.modelBalls) {
            this.ballSpace = new Continuous3D(Math.max(this.trapGridHeight, this.trapGridWidth) * 2, this.spaceWidth, this.spaceHeight, this.spaceLength);
        }
    }

    public int discretizeX(double position) {
        int i = (int)(position * this.oneOverSpaceWidth * (double)this.trapGridWidth);
        if (this.toroidalWorld) {
            return (i + this.trapGridWidth) % this.trapGridWidth;
        }
        i += 2 * this.trapGridWidth;
        if ((i %= 2 * this.trapGridWidth) < this.trapGridWidth) {
            return i;
        }
        return this.trapGridWidth - i;
    }

    public int discretizeY(double position) {
        int i = (int)(position * this.oneOverSpaceHeight * (double)this.trapGridHeight);
        if (this.toroidalWorld) {
            return (i + this.trapGridHeight) % this.trapGridHeight;
        }
        i += 2 * this.trapGridHeight;
        if ((i %= 2 * this.trapGridHeight) < this.trapGridHeight) {
            return i;
        }
        return this.trapGridHeight - i;
    }

    public int discretizeX(double offset, int location) {
        return this.discretizeX(offset + (0.5 + (double)location) * this.trapSizeX);
    }

    public int discretizeY(double offset, int location) {
        return this.discretizeY(offset + (0.5 + (double)location) * this.trapSizeY);
    }

    public double trapPosX(int x) {
        return (0.5 + (double)x) * this.trapSizeX;
    }

    public double trapPosY(int y) {
        return (0.5 + (double)y) * this.trapSizeY;
    }

    public void triggerTrap(int posx, int posy) {
        if (this.trapStateGrid.get(posx, posy) == 1) {
            return;
        }
        this.trapStateGrid.set(posx, posy, 1);
        double spacePosX = (0.5 + (double)posx) * this.trapSizeX;
        double spacePosY = (0.5 + (double)posy) * this.trapSizeY;
        int i = 0;
        while (i < 2) {
            double azimuth = this.random.nextDouble() * (Math.PI * 2);
            double elevation = this.random.nextDouble() * 1.5707963267948966;
            double cos_elevation = Math.cos(elevation);
            double sin_elevation = Math.sqrt(1.0 - cos_elevation * cos_elevation);
            double cos_azimuth = Math.cos(azimuth);
            double sin_azimuth = Math.sin(azimuth);
            double vz = this.initialVelocity * sin_elevation;
            double vxy = this.initialVelocity * cos_elevation;
            double vx = vxy * cos_azimuth;
            double vy = vxy * sin_azimuth;
            if (!this.modelBalls) {
                double landing_time = vz * 0.2040816326530612;
                double landing_dx = vx * landing_time;
                double landing_dy = vy * landing_time;
                this.schedule.scheduleOnce(this.schedule.getTime() + landing_time, (Steppable)new MouseTrap(this.discretizeX(landing_dx, posx), this.discretizeY(landing_dy, posy)));
            } else {
                Ball b = new Ball(spacePosX, spacePosY, 0.0, vx, vy, vz);
                this.ballSpace.setObjectLocation((Object)b, new Double3D(spacePosX, spacePosY, 0.0));
                this.schedule.scheduleOnce(this.schedule.getTime() + 1.0, (Steppable)b);
            }
            ++i;
        }
    }

    @Override
    public void start() {
        super.start();
        this.createGrids();
        int posx = this.trapGridWidth / 2;
        int posy = this.trapGridHeight / 2;
        if (this.modelBalls) {
            double x = (0.5 + (double)posx) * this.trapSizeX;
            double y = (0.5 + (double)posy) * this.trapSizeY;
            double z = this.computeFishTankCeiling();
            Ball b = new Ball(x, y, z, 0.0, 0.0, 0.0);
            this.ballSpace.setObjectLocation((Object)b, new Double3D(x, y, z));
            this.schedule.scheduleOnce(0.0, (Steppable)b);
        } else {
            this.schedule.scheduleOnce(this.initialVelocity * 9.8, (Steppable)new MouseTrap(posx, posy));
        }
    }

    public static void main(String[] args) {
        MouseTraps.doLoop(MouseTraps.class, args);
        System.exit(0);
    }
}

