/*
 * Decompiled with CFR 0.152.
 */
package sim.app.lsystem;

import sim.app.lsystem.ByteList;
import sim.app.lsystem.LSystem;
import sim.app.lsystem.LSystemData;
import sim.app.lsystem.Segment;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.engine.Stoppable;
import sim.util.Bag;
import sim.util.Double2D;
import sim.util.Double3D;

public class LSystemDrawer
implements Steppable {
    private static final long serialVersionUID = 1L;
    ByteList code;
    int draw_time;
    double x;
    double y;
    double theta;
    double angle;
    double segsize;
    public Bag stack;
    Segment s;
    public Stoppable stopper;

    LSystemDrawer(LSystemData l) {
        this.code = new ByteList(l.code);
        this.x = l.x;
        this.y = l.y;
        this.angle = l.angle;
        this.theta = l.theta;
        this.segsize = l.segsize;
        this.draw_time = -1;
        this.stack = new Bag();
    }

    @Override
    public void step(SimState state) {
        block8: {
            LSystem ls = (LSystem)state;
            while (true) {
                ++this.draw_time;
                if (this.draw_time >= this.code.length) {
                    if (this.stopper != null) {
                        this.stopper.stop();
                    }
                    return;
                }
                if (this.code.b[this.draw_time] == 91) {
                    this.stack.push(new Double3D(this.x, this.y, this.theta));
                    continue;
                }
                if (this.code.b[this.draw_time] == 93) {
                    Double3D d = (Double3D)this.stack.pop();
                    this.x = d.x;
                    this.y = d.y;
                    this.theta = d.z;
                    continue;
                }
                if (this.code.b[this.draw_time] == 45) {
                    this.theta += this.angle;
                    continue;
                }
                if (this.code.b[this.draw_time] == 43) {
                    this.theta -= this.angle;
                    continue;
                }
                if (this.code.b[this.draw_time] >= 65 && this.code.b[this.draw_time] <= 90) {
                    this.s = new Segment(this.x, this.y, this.segsize, this.theta);
                    ls.drawEnvironment.setObjectLocation((Object)this.s, new Double2D(this.s.x, this.s.y));
                    this.x += this.segsize * Math.cos(this.theta);
                    this.y += this.segsize * Math.sin(this.theta);
                    break block8;
                }
                if (this.code.b[this.draw_time] < 97 || this.code.b[this.draw_time] > 122) break;
                this.x += this.segsize * Math.cos(this.theta);
                this.y += this.segsize * Math.sin(this.theta);
            }
            System.err.println("Error--bad code:  " + (char)this.code.b[this.draw_time]);
        }
    }
}

