/*
 * Decompiled with CFR 0.152.
 */
package sim.app.lightcycles;

import sim.app.lightcycles.Cycle;
import sim.engine.SimState;
import sim.field.grid.IntGrid2D;
import sim.field.grid.SparseGrid2D;

public class LightCycles
extends SimState {
    private static final long serialVersionUID = 1L;
    public int gridHeight;
    public int gridWidth;
    public int cycleCount;
    public IntGrid2D grid;
    public SparseGrid2D cycleGrid;

    public LightCycles(long seed) {
        this(seed, 100, 100, 10);
    }

    public LightCycles(long seed, int width, int height, int count) {
        super(seed);
        this.gridWidth = width;
        this.gridHeight = height;
        this.cycleCount = count;
        this.createGrids();
    }

    protected void createGrids() {
        this.grid = new IntGrid2D(this.gridWidth, this.gridHeight, 0);
        this.cycleGrid = new SparseGrid2D(this.gridWidth, this.gridHeight);
    }

    @Override
    public void start() {
        super.start();
        this.createGrids();
        int x = 0;
        while (x < this.cycleCount) {
            Cycle c = new Cycle(x + 1, this.random.nextInt(4) + 1);
            this.cycleGrid.setObjectLocation(c, this.random.nextInt(this.gridWidth), this.random.nextInt(this.gridHeight));
            c.stopper = this.schedule.scheduleRepeating(c);
            ++x;
        }
    }

    public static void main(String[] args) {
        LightCycles.doLoop(LightCycles.class, args);
        System.exit(0);
    }
}

