/*
 * Decompiled with CFR 0.152.
 */
package sim.app.celegans;

import java.awt.Color;
import javax.swing.JFrame;
import sim.app.celegans.Celegans;
import sim.app.celegans.CellPortrayal;
import sim.display.Controller;
import sim.display.GUIState;
import sim.display3d.Display3D;
import sim.engine.SimState;
import sim.portrayal3d.continuous.ContinuousPortrayal3D;
import sim.portrayal3d.network.NetworkPortrayal3D;
import sim.portrayal3d.network.SimpleEdgePortrayal3D;
import sim.portrayal3d.network.SpatialNetwork3D;
import sim.portrayal3d.simple.SpherePortrayal3D;

public class CelegansWithUI
extends GUIState {
    public Display3D display;
    public Display3D neuronDisplay;
    public JFrame displayFrame;
    public JFrame neuronDisplayFrame;
    ContinuousPortrayal3D nodePortrayal = new ContinuousPortrayal3D();
    ContinuousPortrayal3D neuronPortrayal = new ContinuousPortrayal3D();
    NetworkPortrayal3D synapsePortrayal = new NetworkPortrayal3D();

    public static void main(String[] args) {
        new CelegansWithUI().createController();
    }

    public CelegansWithUI() {
        super(new Celegans(System.currentTimeMillis()));
    }

    public CelegansWithUI(SimState state) {
        super(state);
    }

    public static String getName() {
        return "Caenorhabditis elegans";
    }

    @Override
    public Object getSimulationInspectedObject() {
        return this.state;
    }

    @Override
    public void start() {
        super.start();
        this.setupPortrayals();
    }

    @Override
    public void load(SimState state) {
        super.load(state);
        this.setupPortrayals();
    }

    public void setupPortrayals() {
        Celegans tut = (Celegans)this.state;
        this.nodePortrayal.setField(tut.cells);
        this.nodePortrayal.setPortrayalForAll(new CellPortrayal(50.0));
        this.neuronPortrayal.setField(tut.neurons);
        this.neuronPortrayal.setPortrayalForAll(new SpherePortrayal3D());
        this.synapsePortrayal.setField(new SpatialNetwork3D(tut.neurons, tut.synapses));
        this.synapsePortrayal.setPortrayalForAll(new SimpleEdgePortrayal3D(Color.red, Color.blue, Color.white));
        this.display.createSceneGraph();
        this.display.reset();
    }

    @Override
    public void init(Controller c) {
        super.init(c);
        Celegans tut = (Celegans)this.state;
        this.display = new Display3D(600.0, 600.0, this);
        this.display.attach(this.nodePortrayal, "Cells");
        this.display.scale(0.025);
        this.display.setSelectsAll(false, true);
        this.displayFrame = this.display.createFrame();
        this.displayFrame.setTitle("Embryo");
        c.registerFrame(this.displayFrame);
        this.displayFrame.setVisible(true);
        this.neuronDisplay = new Display3D(400.0, 400.0, this);
        this.neuronDisplay.attach(this.neuronPortrayal, "Neurons");
        this.neuronDisplay.attach(this.synapsePortrayal, "Synapses");
        this.neuronDisplay.scale(0.025);
        this.neuronDisplay.setSelectsAll(false, true);
        this.neuronDisplayFrame = this.neuronDisplay.createFrame();
        this.neuronDisplayFrame.setTitle("Synapses");
        c.registerFrame(this.neuronDisplayFrame);
    }

    @Override
    public void quit() {
        super.quit();
        if (this.displayFrame != null) {
            this.displayFrame.dispose();
        }
        this.displayFrame = null;
        this.display = null;
        if (this.neuronDisplayFrame != null) {
            this.neuronDisplayFrame.dispose();
        }
        this.neuronDisplayFrame = null;
        this.neuronDisplay = null;
    }
}

