/*
 * Decompiled with CFR 0.152.
 */
package sim.app.balls3d;

import sim.app.balls3d.Ball;
import sim.app.balls3d.Band;
import sim.engine.Sequence;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.field.continuous.Continuous3D;
import sim.field.network.Network;
import sim.util.Bag;
import sim.util.Double3D;

public class Balls3D
extends SimState {
    private static final long serialVersionUID = 1L;
    public Continuous3D balls;
    public Network bands;
    public int numBalls = 50;
    public int numBands = 60;
    public double gridWidth = 100.0;
    public double gridHeight = 100.0;
    public double gridLength = 100.0;
    public static final double maxMass = 10.0;
    public static final double minMass = 1.0;
    public static final double minLaxBandDistance = 10.0;
    public static final double maxLaxBandDistance = 50.0;
    public static final double minBandStrength = 5.0;
    public static final double maxBandStrength = 10.0;
    public static final double collisionDistance = 5.0;

    public int getNumBalls() {
        return this.numBalls;
    }

    public void setNumBalls(int val) {
        if (val >= 2) {
            this.numBalls = val;
        }
    }

    public int getNumBands() {
        return this.numBands;
    }

    public void setNumBands(int val) {
        if (val >= 0) {
            this.numBands = val;
        }
    }

    public Balls3D(long seed) {
        super(seed);
    }

    @Override
    public void start() {
        super.start();
        this.balls = new Continuous3D(5.0, this.gridWidth, this.gridHeight, this.gridLength);
        this.bands = new Network();
        Steppable[] s = new Steppable[this.numBalls];
        int i = 0;
        while (i < this.numBalls) {
            final Ball ball = new Ball(0.0, 0.0, 0.0, this.random.nextDouble() * 9.0 + 1.0);
            this.balls.setObjectLocation((Object)ball, new Double3D(this.random.nextDouble() * this.gridWidth, this.random.nextDouble() * this.gridHeight, this.random.nextDouble() * this.gridLength));
            this.bands.addNode(ball);
            this.schedule.scheduleRepeating(ball);
            s[i] = new Steppable(){
                static final long serialVersionUID = -4269174171145445918L;

                @Override
                public void step(SimState state) {
                    ball.computeForce(state);
                }
            };
            ++i;
        }
        this.schedule.scheduleRepeating(0.0, 1, new Sequence(s), 1.0);
        Bag ballObjs = this.balls.getAllObjects();
        int i2 = 0;
        while (i2 < this.numBands) {
            Ball from;
            Band band = new Band(this.random.nextDouble() * 40.0 + 10.0, this.random.nextDouble() * 5.0 + 5.0);
            Ball to = from = (Ball)ballObjs.objs[this.random.nextInt(ballObjs.numObjs)];
            while (to == from) {
                to = (Ball)ballObjs.objs[this.random.nextInt(ballObjs.numObjs)];
            }
            this.bands.addEdge(from, to, band);
            ++i2;
        }
        ballObjs = this.balls.getAllObjects();
        i2 = 0;
        while (i2 < ballObjs.numObjs) {
            ((Ball)ballObjs.objs[i2]).computeCollision(this);
            ++i2;
        }
    }

    public static void main(String[] args) {
        Balls3D.doLoop(Balls3D.class, args);
        System.exit(0);
    }
}

