/*
 * Decompiled with CFR 0.152.
 */
package sim.app.asteroids;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import sim.app.asteroids.Asteroid;
import sim.app.asteroids.Asteroids;
import sim.app.asteroids.Bullet;
import sim.app.asteroids.Element;
import sim.app.asteroids.Fire;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.portrayal.DrawInfo2D;
import sim.util.Bag;
import sim.util.Double2D;
import sim.util.MutableDouble2D;

public class Ship
extends Element {
    private static final long serialVersionUID = 1L;
    public int tag;
    public Fire fire = new Fire();
    int bulletCountdown;
    public static final int BULLET_COUNTDOWN = 10;
    public static final double MAXIMUM_RADIUS = 6.0;
    public static final double VELOCITY_INCREMENT = 0.03;
    public static final double ORIENTATION_INCREMENT = 0.05;
    public static final int MAXIMUM_THRUST_DRAW_LENGTH = 5;
    public static final int NOTHING = 0;
    public static final int LEFT = 1;
    public static final int FORWARD = 2;
    public static final int RIGHT = 4;
    public static final int FIRE = 8;
    public static final int HYPERSPACE = 16;
    int thrust = 0;

    public Ship(Asteroids asteroids, MutableDouble2D velocity, Double2D location, int tag) {
        this.velocity = velocity;
        this.rotationalVelocity = 0.0;
        this.stopper = asteroids.schedule.scheduleRepeating(this);
        this.orientation = asteroids.random.nextDouble() * Math.PI * 2.0;
        asteroids.field.setObjectLocation((Object)this, location);
        GeneralPath gp = new GeneralPath();
        gp.moveTo(-2.0f, -2.0f);
        gp.lineTo(2.0f, 0.0f);
        gp.lineTo(-2.0f, 2.0f);
        gp.lineTo(0.0f, 0.0f);
        gp.closePath();
        this.shape = gp;
        this.tag = tag;
    }

    public void shoot(Asteroids asteroids) {
        if (this.bulletCountdown <= 0) {
            this.bulletCountdown = 10;
            MutableDouble2D v2 = new MutableDouble2D(this.velocity);
            v2.x += 1.0 * Math.cos(this.orientation);
            v2.y += 1.0 * Math.sin(this.orientation);
            Double2D location = asteroids.field.getObjectLocation(this);
            Double2D l2 = new Double2D(location.x + 7.0 * Math.cos(this.orientation), location.y + 7.0 * Math.sin(this.orientation));
            Bullet bullet = new Bullet(asteroids, v2, l2, 100);
        }
    }

    @Override
    public void step(SimState state) {
        Asteroids asteroids = (Asteroids)state;
        if ((asteroids.actions[this.tag] & 2) == 2) {
            this.velocity.x += Math.cos(this.orientation) * 0.03;
            this.velocity.y += Math.sin(this.orientation) * 0.03;
            this.thrust = 5;
        }
        if ((asteroids.actions[this.tag] & 1) == 1) {
            this.orientation -= 0.05;
        }
        if ((asteroids.actions[this.tag] & 4) == 4) {
            this.orientation += 0.05;
        }
        if ((asteroids.actions[this.tag] & 8) == 8) {
            this.shoot(asteroids);
            int n = this.tag;
            asteroids.actions[n] = asteroids.actions[n] & 0xFFFFFFF7;
        }
        if ((asteroids.actions[this.tag] & 0x10) == 16) {
            asteroids.field.setObjectLocation((Object)this, new Double2D(asteroids.random.nextDouble() * asteroids.field.width, asteroids.random.nextDouble() * asteroids.field.height));
            int n = this.tag;
            asteroids.actions[n] = asteroids.actions[n] & 0xFFFFFFEF;
        }
        super.step(state);
        this.testForHit(asteroids);
        --this.bulletCountdown;
    }

    @Override
    public Color getColor() {
        return Color.green;
    }

    @Override
    public void draw(Object object, Graphics2D graphics, DrawInfo2D info) {
        super.draw(object, graphics, info);
        if (this.thrust > 0) {
            this.fire.orientation = this.orientation;
            this.fire.draw(object, graphics, info);
        }
        --this.thrust;
    }

    void respawn(final Asteroids asteroids) {
        asteroids.schedule.scheduleOnceIn(60.0, new Steppable(){

            @Override
            public void step(SimState state) {
                Double2D respawnLocation = new Double2D(asteroids.width / 2.0, asteroids.height / 2.0);
                Bag o = asteroids.field.getAllObjects();
                boolean safe = true;
                int i = 0;
                while (i < o.numObjs) {
                    Double2D loc = asteroids.field.getObjectLocation(o.objs[i]);
                    if (loc.distance(respawnLocation) < 30.0) {
                        safe = false;
                        break;
                    }
                    ++i;
                }
                if (safe) {
                    asteroids.createShip(Ship.this.tag);
                } else {
                    Ship.this.respawn(asteroids);
                }
            }
        });
    }

    public void testForHit(Asteroids asteroids) {
        Bag a = asteroids.field.getAllObjects();
        int i = 0;
        while (i < a.numObjs) {
            Asteroid asteroid;
            Object obj = a.objs[i];
            if (obj instanceof Asteroid && (asteroid = (Asteroid)a.objs[i]).collisionWithElement(asteroids, this)) {
                asteroid.breakApart(asteroids);
                this.breakIntoShards(asteroids);
                ++asteroids.score;
                ++asteroids.deaths;
                asteroids.ships[this.tag] = null;
                this.end(asteroids);
                this.respawn(asteroids);
                break;
            }
            ++i;
        }
    }
}

