/*
 * Decompiled with CFR 0.152.
 */
package sim.app.antsforage;

import sim.app.antsforage.Ant;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.field.grid.DoubleGrid2D;
import sim.field.grid.IntGrid2D;
import sim.field.grid.SparseGrid2D;
import sim.util.Interval;

public class AntsForage
extends SimState {
    private static final long serialVersionUID = 1L;
    public static final int GRID_HEIGHT = 100;
    public static final int GRID_WIDTH = 100;
    public static final int HOME_XMIN = 75;
    public static final int HOME_XMAX = 75;
    public static final int HOME_YMIN = 75;
    public static final int HOME_YMAX = 75;
    public static final int FOOD_XMIN = 25;
    public static final int FOOD_XMAX = 25;
    public static final int FOOD_YMIN = 25;
    public static final int FOOD_YMAX = 25;
    public static final int NO_OBSTACLES = 0;
    public static final int ONE_OBSTACLE = 1;
    public static final int TWO_OBSTACLES = 2;
    public static final int ONE_LONG_OBSTACLE = 3;
    public static final int OBSTACLES = 2;
    public static final int ALGORITHM_VALUE_ITERATION = 1;
    public static final int ALGORITHM_TEMPORAL_DIFERENCE = 2;
    public static final int ALGORITHM = 1;
    public static final double IMPOSSIBLY_BAD_PHEROMONE = -1.0;
    public static final double LIKELY_MAX_PHEROMONE = 3.0;
    public static final int HOME = 1;
    public static final int FOOD = 2;
    public int numAnts = 1000;
    public double evaporationConstant = 0.999;
    public double reward = 1.0;
    public double updateCutDown = 0.9;
    public double diagonalCutDown = this.computeDiagonalCutDown();
    public double momentumProbability = 0.8;
    public double randomActionProbability = 0.1;
    public IntGrid2D sites = new IntGrid2D(100, 100, 0);
    public DoubleGrid2D toFoodGrid = new DoubleGrid2D(100, 100, 0.0);
    public DoubleGrid2D toHomeGrid = new DoubleGrid2D(100, 100, 0.0);
    public SparseGrid2D buggrid = new SparseGrid2D(100, 100);
    public IntGrid2D obstacles = new IntGrid2D(100, 100, 0);

    public double computeDiagonalCutDown() {
        return Math.pow(this.updateCutDown, Math.sqrt(2.0));
    }

    public int getNumAnts() {
        return this.numAnts;
    }

    public void setNumAnts(int val) {
        if (val > 0) {
            this.numAnts = val;
        }
    }

    public double getEvaporationConstant() {
        return this.evaporationConstant;
    }

    public void setEvaporationConstant(double val) {
        if (val >= 0.0 && val <= 1.0) {
            this.evaporationConstant = val;
        }
    }

    public double getReward() {
        return this.reward;
    }

    public void setReward(double val) {
        if (val >= 0.0) {
            this.reward = val;
        }
    }

    public double getCutDown() {
        return this.updateCutDown;
    }

    public void setCutDown(double val) {
        if (val >= 0.0 && val <= 1.0) {
            this.updateCutDown = val;
        }
        this.diagonalCutDown = this.computeDiagonalCutDown();
    }

    public Object domCutDown() {
        return new Interval(0.0, 1.0);
    }

    public double getMomentumProbability() {
        return this.momentumProbability;
    }

    public void setMomentumProbability(double val) {
        if (val >= 0.0 && val <= 1.0) {
            this.momentumProbability = val;
        }
    }

    public Object domMomentumProbability() {
        return new Interval(0.0, 1.0);
    }

    public double getRandomActionProbability() {
        return this.randomActionProbability;
    }

    public void setRandomActionProbability(double val) {
        if (val >= 0.0 && val <= 1.0) {
            this.randomActionProbability = val;
        }
    }

    public Object domRandomActionProbability() {
        return new Interval(0.0, 1.0);
    }

    public AntsForage(long seed) {
        super(seed);
    }

    @Override
    public void start() {
        int y;
        int x;
        super.start();
        this.sites = new IntGrid2D(100, 100, 0);
        this.toFoodGrid = new DoubleGrid2D(100, 100, 0.0);
        this.toHomeGrid = new DoubleGrid2D(100, 100, 0.0);
        this.buggrid = new SparseGrid2D(100, 100);
        this.obstacles = new IntGrid2D(100, 100, 0);
        switch (2) {
            case 0: {
                break;
            }
            case 1: {
                x = 0;
                while (x < 100) {
                    y = 0;
                    while (y < 100) {
                        this.obstacles.field[x][y] = 0;
                        if (((double)(x - 55) * 0.707 + (double)(y - 35) * 0.707) * ((double)(x - 55) * 0.707 + (double)(y - 35) * 0.707) / 36.0 + ((double)(x - 55) * 0.707 - (double)(y - 35) * 0.707) * ((double)(x - 55) * 0.707 - (double)(y - 35) * 0.707) / 1024.0 <= 1.0) {
                            this.obstacles.field[x][y] = 1;
                        }
                        ++y;
                    }
                    ++x;
                }
                break;
            }
            case 2: {
                x = 0;
                while (x < 100) {
                    y = 0;
                    while (y < 100) {
                        this.obstacles.field[x][y] = 0;
                        if (((double)(x - 45) * 0.707 + (double)(y - 25) * 0.707) * ((double)(x - 45) * 0.707 + (double)(y - 25) * 0.707) / 36.0 + ((double)(x - 45) * 0.707 - (double)(y - 25) * 0.707) * ((double)(x - 45) * 0.707 - (double)(y - 25) * 0.707) / 1024.0 <= 1.0) {
                            this.obstacles.field[x][y] = 1;
                        }
                        if (((double)(x - 35) * 0.707 + (double)(y - 70) * 0.707) * ((double)(x - 35) * 0.707 + (double)(y - 70) * 0.707) / 36.0 + ((double)(x - 35) * 0.707 - (double)(y - 70) * 0.707) * ((double)(x - 35) * 0.707 - (double)(y - 70) * 0.707) / 1024.0 <= 1.0) {
                            this.obstacles.field[x][y] = 1;
                        }
                        ++y;
                    }
                    ++x;
                }
                break;
            }
            case 3: {
                x = 0;
                while (x < 100) {
                    y = 0;
                    while (y < 100) {
                        this.obstacles.field[x][y] = 0;
                        if ((x - 60) * (x - 60) / 1600 + (y - 50) * (y - 50) / 25 <= 1) {
                            this.obstacles.field[x][y] = 1;
                        }
                        ++y;
                    }
                    ++x;
                }
                break;
            }
        }
        x = 75;
        while (x <= 75) {
            y = 75;
            while (y <= 75) {
                this.sites.field[x][y] = 1;
                ++y;
            }
            ++x;
        }
        x = 25;
        while (x <= 25) {
            y = 25;
            while (y <= 25) {
                this.sites.field[x][y] = 2;
                ++y;
            }
            ++x;
        }
        x = 0;
        while (x < this.numAnts) {
            Ant ant = new Ant(this.reward);
            this.buggrid.setObjectLocation(ant, 75, 75);
            this.schedule.scheduleRepeating(0.0 + (double)x, 0, ant, 1.0);
            ++x;
        }
        this.schedule.scheduleRepeating(0.0, 1, new Steppable(){

            @Override
            public void step(SimState state) {
                AntsForage.this.toFoodGrid.multiply(AntsForage.this.evaporationConstant);
                AntsForage.this.toHomeGrid.multiply(AntsForage.this.evaporationConstant);
            }
        }, 1.0);
    }

    public static void main(String[] args) {
        AntsForage.doLoop(AntsForage.class, args);
        System.exit(0);
    }
}

