/*
 * Decompiled with CFR 0.152.
 */
package sim.app.antsforage;

import java.awt.Color;
import java.awt.Graphics2D;
import sim.app.antsforage.AntsForage;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.simple.OvalPortrayal2D;
import sim.util.Int2D;

public class Ant
extends OvalPortrayal2D
implements Steppable {
    private static final long serialVersionUID = 1L;
    public boolean hasFoodItem = false;
    double reward = 0.0;
    int x;
    int y;
    Int2D last;
    private Color noFoodColor = Color.black;
    private Color foodColor = Color.red;

    public boolean getHasFoodItem() {
        return this.hasFoodItem;
    }

    public void setHasFoodItem(boolean val) {
        this.hasFoodItem = val;
    }

    public Ant(double initialReward) {
        this.reward = initialReward;
    }

    public void depositPheromone(SimState state) {
        AntsForage af = (AntsForage)state;
        Int2D location = af.buggrid.getObjectLocation(this);
        int x = location.x;
        int y = location.y;
        if (this.hasFoodItem) {
            double max = af.toFoodGrid.field[x][y];
            int dx = -1;
            while (dx < 2) {
                int dy = -1;
                while (dy < 2) {
                    int _x = dx + x;
                    int _y = dy + y;
                    if (_x >= 0 && _y >= 0 && _x < 100 && _y < 100) {
                        double m = af.toFoodGrid.field[_x][_y] * (dx * dy != 0 ? af.diagonalCutDown : af.updateCutDown) + this.reward;
                        if (m > max) {
                            max = m;
                        }
                    }
                    ++dy;
                }
                ++dx;
            }
            af.toFoodGrid.field[x][y] = max;
        } else {
            double max = af.toHomeGrid.field[x][y];
            int dx = -1;
            while (dx < 2) {
                int dy = -1;
                while (dy < 2) {
                    int _x = dx + x;
                    int _y = dy + y;
                    if (_x >= 0 && _y >= 0 && _x < 100 && _y < 100) {
                        double m = af.toHomeGrid.field[_x][_y] * (dx * dy != 0 ? af.diagonalCutDown : af.updateCutDown) + this.reward;
                        if (m > max) {
                            max = m;
                        }
                    }
                    ++dy;
                }
                ++dx;
            }
            af.toHomeGrid.field[x][y] = max;
        }
        this.reward = 0.0;
    }

    public void act(SimState state) {
        AntsForage af = (AntsForage)state;
        Int2D location = af.buggrid.getObjectLocation(this);
        int x = location.x;
        int y = location.y;
        if (this.hasFoodItem) {
            double max = -1.0;
            int max_x = x;
            int max_y = y;
            int count = 2;
            int dx = -1;
            while (dx < 2) {
                int dy = -1;
                while (dy < 2) {
                    int _x = dx + x;
                    int _y = dy + y;
                    if ((dx != 0 || dy != 0) && _x >= 0 && _y >= 0 && _x < 100 && _y < 100 && af.obstacles.field[_x][_y] != 1) {
                        double m = af.toHomeGrid.field[_x][_y];
                        if (m > max) {
                            count = 2;
                        }
                        if (m > max || m == max && state.random.nextBoolean(1.0 / (double)count++)) {
                            max = m;
                            max_x = _x;
                            max_y = _y;
                        }
                    }
                    ++dy;
                }
                ++dx;
            }
            if (max == 0.0 && this.last != null) {
                if (state.random.nextBoolean(af.momentumProbability)) {
                    int xm = x + (x - this.last.x);
                    int ym = y + (y - this.last.y);
                    if (xm >= 0 && xm < 100 && ym >= 0 && ym < 100 && af.obstacles.field[xm][ym] == 0) {
                        max_x = xm;
                        max_y = ym;
                    }
                }
            } else if (state.random.nextBoolean(af.randomActionProbability)) {
                int xd = state.random.nextInt(3) - 1;
                int yd = state.random.nextInt(3) - 1;
                int xm = x + xd;
                int ym = y + yd;
                if ((xd != 0 || yd != 0) && xm >= 0 && xm < 100 && ym >= 0 && ym < 100 && af.obstacles.field[xm][ym] == 0) {
                    max_x = xm;
                    max_y = ym;
                }
            }
            af.buggrid.setObjectLocation((Object)this, new Int2D(max_x, max_y));
            if (af.sites.field[max_x][max_y] == 1) {
                this.reward = af.reward;
                this.hasFoodItem = !this.hasFoodItem;
            }
        } else {
            double max = -1.0;
            int max_x = x;
            int max_y = y;
            int count = 2;
            int dx = -1;
            while (dx < 2) {
                int dy = -1;
                while (dy < 2) {
                    int _x = dx + x;
                    int _y = dy + y;
                    if ((dx != 0 || dy != 0) && _x >= 0 && _y >= 0 && _x < 100 && _y < 100 && af.obstacles.field[_x][_y] != 1) {
                        double m = af.toFoodGrid.field[_x][_y];
                        if (m > max) {
                            count = 2;
                        }
                        if (m > max || m == max && state.random.nextBoolean(1.0 / (double)count++)) {
                            max = m;
                            max_x = _x;
                            max_y = _y;
                        }
                    }
                    ++dy;
                }
                ++dx;
            }
            if (max == 0.0 && this.last != null) {
                if (state.random.nextBoolean(af.momentumProbability)) {
                    int xm = x + (x - this.last.x);
                    int ym = y + (y - this.last.y);
                    if (xm >= 0 && xm < 100 && ym >= 0 && ym < 100 && af.obstacles.field[xm][ym] == 0) {
                        max_x = xm;
                        max_y = ym;
                    }
                }
            } else if (state.random.nextBoolean(af.randomActionProbability)) {
                int xd = state.random.nextInt(3) - 1;
                int yd = state.random.nextInt(3) - 1;
                int xm = x + xd;
                int ym = y + yd;
                if ((xd != 0 || yd != 0) && xm >= 0 && xm < 100 && ym >= 0 && ym < 100 && af.obstacles.field[xm][ym] == 0) {
                    max_x = xm;
                    max_y = ym;
                }
            }
            af.buggrid.setObjectLocation((Object)this, new Int2D(max_x, max_y));
            if (af.sites.field[max_x][max_y] == 2) {
                this.reward = af.reward;
                this.hasFoodItem = !this.hasFoodItem;
            }
        }
        this.last = location;
    }

    @Override
    public void step(SimState state) {
        this.depositPheromone(state);
        this.act(state);
    }

    @Override
    public final void draw(Object object, Graphics2D graphics, DrawInfo2D info) {
        if (this.hasFoodItem) {
            graphics.setColor(this.foodColor);
        } else {
            graphics.setColor(this.noFoodColor);
        }
        int x = (int)(info.draw.x - info.draw.width / 2.0);
        int y = (int)(info.draw.y - info.draw.height / 2.0);
        int width = (int)info.draw.width;
        int height = (int)info.draw.height;
        graphics.fillOval(x, y, width, height);
    }
}

