/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ext;

import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.util.Provider;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;

public class OptionalHandlerFactory
implements Serializable {
    private static final long serialVersionUID = -7103336512296456640L;
    private static final String PACKAGE_PREFIX_JAVAX_XML = "javax.xml.";
    private static final String SERIALIZERS_FOR_JAVAX_XML = "com.fasterxml.jackson.databind.ext.CoreXMLSerializers";
    private static final String DESERIALIZERS_FOR_JAVAX_XML = "com.fasterxml.jackson.databind.ext.CoreXMLDeserializers";
    private static final String CLASS_NAME_DOM_NODE = "org.w3c.dom.Node";
    private static final String CLASS_NAME_DOM_DOCUMENT = "org.w3c.dom.Node";
    private static final String SERIALIZER_FOR_DOM_NODE = "com.fasterxml.jackson.databind.ext.DOMSerializer";
    private static final String DESERIALIZER_FOR_DOM_DOCUMENT = "com.fasterxml.jackson.databind.ext.DOMDeserializer$DocumentDeserializer";
    private static final String DESERIALIZER_FOR_DOM_NODE = "com.fasterxml.jackson.databind.ext.DOMDeserializer$NodeDeserializer";
    public static final OptionalHandlerFactory instance = new OptionalHandlerFactory();

    protected OptionalHandlerFactory() {
    }

    public JsonSerializer<?> findSerializer(SerializationConfig config, JavaType type) {
        Class<?> rawType = type.getRawClass();
        String className = rawType.getName();
        if (!className.startsWith(PACKAGE_PREFIX_JAVAX_XML) && !this.hasSupertypeStartingWith(rawType, PACKAGE_PREFIX_JAVAX_XML)) {
            if (this.doesImplement(rawType, "org.w3c.dom.Node")) {
                return (JsonSerializer)this.instantiate(SERIALIZER_FOR_DOM_NODE);
            }
            return null;
        }
        String factoryName = SERIALIZERS_FOR_JAVAX_XML;
        Object ob = this.instantiate(factoryName);
        if (ob == null) {
            return null;
        }
        Provider prov = (Provider)ob;
        Collection entries = prov.provide();
        for (Map.Entry entry : entries) {
            if (rawType != entry.getKey()) continue;
            return (JsonSerializer)entry.getValue();
        }
        for (Map.Entry entry : entries) {
            if (!((Class)entry.getKey()).isAssignableFrom(rawType)) continue;
            return (JsonSerializer)entry.getValue();
        }
        return null;
    }

    public JsonDeserializer<?> findDeserializer(JavaType type, DeserializationConfig config) {
        Class<?> rawType = type.getRawClass();
        String className = rawType.getName();
        if (!className.startsWith(PACKAGE_PREFIX_JAVAX_XML) && !this.hasSupertypeStartingWith(rawType, PACKAGE_PREFIX_JAVAX_XML)) {
            if (this.doesImplement(rawType, "org.w3c.dom.Node")) {
                return (JsonDeserializer)this.instantiate(DESERIALIZER_FOR_DOM_DOCUMENT);
            }
            if (this.doesImplement(rawType, "org.w3c.dom.Node")) {
                return (JsonDeserializer)this.instantiate(DESERIALIZER_FOR_DOM_NODE);
            }
            return null;
        }
        String factoryName = DESERIALIZERS_FOR_JAVAX_XML;
        Object ob = this.instantiate(factoryName);
        if (ob == null) {
            return null;
        }
        Provider prov = (Provider)ob;
        Collection entries = prov.provide();
        for (StdDeserializer deser : entries) {
            if (rawType != deser.getValueClass()) continue;
            return deser;
        }
        for (StdDeserializer deser : entries) {
            if (!deser.getValueClass().isAssignableFrom(rawType)) continue;
            return deser;
        }
        return null;
    }

    private Object instantiate(String className) {
        try {
            return Class.forName(className).newInstance();
        }
        catch (LinkageError e) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private boolean doesImplement(Class<?> actualType, String classNameToImplement) {
        for (Class<?> type = actualType; type != null; type = type.getSuperclass()) {
            if (type.getName().equals(classNameToImplement)) {
                return true;
            }
            if (!this.hasInterface(type, classNameToImplement)) continue;
            return true;
        }
        return false;
    }

    private boolean hasInterface(Class<?> type, String interfaceToImplement) {
        Class<?>[] interfaces;
        for (Class<?> iface : interfaces = type.getInterfaces()) {
            if (!iface.getName().equals(interfaceToImplement)) continue;
            return true;
        }
        for (Class<?> iface : interfaces) {
            if (!this.hasInterface(iface, interfaceToImplement)) continue;
            return true;
        }
        return false;
    }

    private boolean hasSupertypeStartingWith(Class<?> rawType, String prefix) {
        for (Class<?> supertype = rawType.getSuperclass(); supertype != null; supertype = supertype.getSuperclass()) {
            if (!supertype.getName().startsWith(prefix)) continue;
            return true;
        }
        for (Class<?> cls = rawType; cls != null; cls = cls.getSuperclass()) {
            if (!this.hasInterfaceStartingWith(cls, prefix)) continue;
            return true;
        }
        return false;
    }

    private boolean hasInterfaceStartingWith(Class<?> type, String prefix) {
        Class<?>[] interfaces;
        for (Class<?> iface : interfaces = type.getInterfaces()) {
            if (!iface.getName().startsWith(prefix)) continue;
            return true;
        }
        for (Class<?> iface : interfaces) {
            if (!this.hasInterfaceStartingWith(iface, prefix)) continue;
            return true;
        }
        return false;
    }
}

