/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.simpleworkflow.model.SignalWorkflowExecutionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignalWorkflowExecutionRequestMarshaller
implements Marshaller<Request<SignalWorkflowExecutionRequest>, SignalWorkflowExecutionRequest> {
    @Override
    public Request<SignalWorkflowExecutionRequest> marshall(SignalWorkflowExecutionRequest signalWorkflowExecutionRequest) {
        if (signalWorkflowExecutionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SignalWorkflowExecutionRequest> request = new DefaultRequest<SignalWorkflowExecutionRequest>(signalWorkflowExecutionRequest, "AmazonSimpleWorkflow");
        String target = "SimpleWorkflowService.SignalWorkflowExecution";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (signalWorkflowExecutionRequest.getDomain() != null) {
                jsonWriter.key("domain").value(signalWorkflowExecutionRequest.getDomain());
            }
            if (signalWorkflowExecutionRequest.getWorkflowId() != null) {
                jsonWriter.key("workflowId").value(signalWorkflowExecutionRequest.getWorkflowId());
            }
            if (signalWorkflowExecutionRequest.getRunId() != null) {
                jsonWriter.key("runId").value(signalWorkflowExecutionRequest.getRunId());
            }
            if (signalWorkflowExecutionRequest.getSignalName() != null) {
                jsonWriter.key("signalName").value(signalWorkflowExecutionRequest.getSignalName());
            }
            if (signalWorkflowExecutionRequest.getInput() != null) {
                jsonWriter.key("input").value(signalWorkflowExecutionRequest.getInput());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

