/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.VpcPeeringConnectionStateReason;
import com.amazonaws.services.ec2.model.VpcPeeringConnectionVpcInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VpcPeeringConnection
implements Serializable {
    private VpcPeeringConnectionVpcInfo accepterVpcInfo;
    private Date expirationTime;
    private VpcPeeringConnectionVpcInfo requesterVpcInfo;
    private VpcPeeringConnectionStateReason status;
    private ListWithAutoConstructFlag<Tag> tags;
    private String vpcPeeringConnectionId;

    public VpcPeeringConnectionVpcInfo getAccepterVpcInfo() {
        return this.accepterVpcInfo;
    }

    public void setAccepterVpcInfo(VpcPeeringConnectionVpcInfo accepterVpcInfo) {
        this.accepterVpcInfo = accepterVpcInfo;
    }

    public VpcPeeringConnection withAccepterVpcInfo(VpcPeeringConnectionVpcInfo accepterVpcInfo) {
        this.accepterVpcInfo = accepterVpcInfo;
        return this;
    }

    public Date getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(Date expirationTime) {
        this.expirationTime = expirationTime;
    }

    public VpcPeeringConnection withExpirationTime(Date expirationTime) {
        this.expirationTime = expirationTime;
        return this;
    }

    public VpcPeeringConnectionVpcInfo getRequesterVpcInfo() {
        return this.requesterVpcInfo;
    }

    public void setRequesterVpcInfo(VpcPeeringConnectionVpcInfo requesterVpcInfo) {
        this.requesterVpcInfo = requesterVpcInfo;
    }

    public VpcPeeringConnection withRequesterVpcInfo(VpcPeeringConnectionVpcInfo requesterVpcInfo) {
        this.requesterVpcInfo = requesterVpcInfo;
        return this;
    }

    public VpcPeeringConnectionStateReason getStatus() {
        return this.status;
    }

    public void setStatus(VpcPeeringConnectionStateReason status) {
        this.status = status;
    }

    public VpcPeeringConnection withStatus(VpcPeeringConnectionStateReason status) {
        this.status = status;
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new ListWithAutoConstructFlag();
            this.tags.setAutoConstruct(true);
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
        tagsCopy.addAll(tags);
        this.tags = tagsCopy;
    }

    public VpcPeeringConnection withTags(Tag ... tags) {
        if (this.getTags() == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag value : tags) {
            this.getTags().add(value);
        }
        return this;
    }

    public VpcPeeringConnection withTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
        } else {
            ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
            tagsCopy.addAll(tags);
            this.tags = tagsCopy;
        }
        return this;
    }

    public String getVpcPeeringConnectionId() {
        return this.vpcPeeringConnectionId;
    }

    public void setVpcPeeringConnectionId(String vpcPeeringConnectionId) {
        this.vpcPeeringConnectionId = vpcPeeringConnectionId;
    }

    public VpcPeeringConnection withVpcPeeringConnectionId(String vpcPeeringConnectionId) {
        this.vpcPeeringConnectionId = vpcPeeringConnectionId;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccepterVpcInfo() != null) {
            sb.append("AccepterVpcInfo: " + this.getAccepterVpcInfo() + ",");
        }
        if (this.getExpirationTime() != null) {
            sb.append("ExpirationTime: " + this.getExpirationTime() + ",");
        }
        if (this.getRequesterVpcInfo() != null) {
            sb.append("RequesterVpcInfo: " + this.getRequesterVpcInfo() + ",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: " + this.getStatus() + ",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags() + ",");
        }
        if (this.getVpcPeeringConnectionId() != null) {
            sb.append("VpcPeeringConnectionId: " + this.getVpcPeeringConnectionId());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccepterVpcInfo() == null ? 0 : this.getAccepterVpcInfo().hashCode());
        hashCode = 31 * hashCode + (this.getExpirationTime() == null ? 0 : this.getExpirationTime().hashCode());
        hashCode = 31 * hashCode + (this.getRequesterVpcInfo() == null ? 0 : this.getRequesterVpcInfo().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getVpcPeeringConnectionId() == null ? 0 : this.getVpcPeeringConnectionId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcPeeringConnection)) {
            return false;
        }
        VpcPeeringConnection other = (VpcPeeringConnection)obj;
        if (other.getAccepterVpcInfo() == null ^ this.getAccepterVpcInfo() == null) {
            return false;
        }
        if (other.getAccepterVpcInfo() != null && !other.getAccepterVpcInfo().equals(this.getAccepterVpcInfo())) {
            return false;
        }
        if (other.getExpirationTime() == null ^ this.getExpirationTime() == null) {
            return false;
        }
        if (other.getExpirationTime() != null && !other.getExpirationTime().equals(this.getExpirationTime())) {
            return false;
        }
        if (other.getRequesterVpcInfo() == null ^ this.getRequesterVpcInfo() == null) {
            return false;
        }
        if (other.getRequesterVpcInfo() != null && !other.getRequesterVpcInfo().equals(this.getRequesterVpcInfo())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getVpcPeeringConnectionId() == null ^ this.getVpcPeeringConnectionId() == null) {
            return false;
        }
        return other.getVpcPeeringConnectionId() == null || other.getVpcPeeringConnectionId().equals(this.getVpcPeeringConnectionId());
    }
}

