/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.ConditionalOperator;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamoDBScanExpression {
    private Map<String, Condition> scanFilter;
    private Map<String, AttributeValue> exclusiveStartKey;
    private Integer limit;
    private Integer totalSegments;
    private Integer segment;
    private String conditionalOperator;

    public Map<String, Condition> getScanFilter() {
        return this.scanFilter;
    }

    public void setScanFilter(Map<String, Condition> scanFilter) {
        this.scanFilter = scanFilter;
    }

    public DynamoDBScanExpression withScanFilter(Map<String, Condition> scanFilter) {
        this.setScanFilter(scanFilter);
        return this;
    }

    public void addFilterCondition(String attributeName, Condition condition) {
        if (this.scanFilter == null) {
            this.scanFilter = new HashMap<String, Condition>();
        }
        this.scanFilter.put(attributeName, condition);
    }

    public DynamoDBScanExpression withFilterConditionEntry(String attributeName, Condition condition) {
        if (this.scanFilter == null) {
            this.scanFilter = new HashMap<String, Condition>();
        }
        this.scanFilter.put(attributeName, condition);
        return this;
    }

    public Map<String, AttributeValue> getExclusiveStartKey() {
        return this.exclusiveStartKey;
    }

    public void setExclusiveStartKey(Map<String, AttributeValue> exclusiveStartKey) {
        this.exclusiveStartKey = exclusiveStartKey;
    }

    public DynamoDBScanExpression withExclusiveStartKey(Map<String, AttributeValue> exclusiveStartKey) {
        this.exclusiveStartKey = exclusiveStartKey;
        return this;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public DynamoDBScanExpression withLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public Integer getTotalSegments() {
        return this.totalSegments;
    }

    public void setTotalSegments(Integer totalSegments) {
        this.totalSegments = totalSegments;
    }

    public DynamoDBScanExpression withTotalSegments(Integer totalSegments) {
        this.setTotalSegments(totalSegments);
        return this;
    }

    public Integer getSegment() {
        return this.segment;
    }

    public void setSegment(Integer segment) {
        this.segment = segment;
    }

    public DynamoDBScanExpression withSegment(Integer segment) {
        this.setSegment(segment);
        return this;
    }

    public String getConditionalOperator() {
        return this.conditionalOperator;
    }

    public void setConditionalOperator(String conditionalOperator) {
        this.conditionalOperator = conditionalOperator;
    }

    public DynamoDBScanExpression withConditionalOperator(String conditionalOperator) {
        this.setConditionalOperator(conditionalOperator);
        return this;
    }

    public void setConditionalOperator(ConditionalOperator conditionalOperator) {
        this.setConditionalOperator(conditionalOperator.toString());
    }

    public DynamoDBScanExpression withConditionalOperator(ConditionalOperator conditionalOperator) {
        return this.withConditionalOperator(conditionalOperator.toString());
    }
}

